/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.springframework.boot.loader.tools.CustomLoaderLayout;
import org.springframework.boot.loader.tools.DefaultLayoutFactory;
import org.springframework.boot.loader.tools.FileUtils;
import org.springframework.boot.loader.tools.JarWriter;
import org.springframework.boot.loader.tools.LaunchScript;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.LayoutFactory;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.boot.loader.tools.MainClassFinder;
import org.springframework.boot.loader.tools.RepackagingLayout;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Repackager {
    private static final String MAIN_CLASS_ATTRIBUTE = "Main-Class";
    private static final String START_CLASS_ATTRIBUTE = "Start-Class";
    private static final String BOOT_VERSION_ATTRIBUTE = "Spring-Boot-Version";
    private static final String BOOT_LIB_ATTRIBUTE = "Spring-Boot-Lib";
    private static final String BOOT_CLASSES_ATTRIBUTE = "Spring-Boot-Classes";
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private static final long FIND_WARNING_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final String SPRING_BOOT_APPLICATION_CLASS_NAME = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private List<MainClassTimeoutWarningListener> mainClassTimeoutListeners = new ArrayList<MainClassTimeoutWarningListener>();
    private String mainClass;
    private boolean backupSource = true;
    private final File source;
    private Layout layout;
    private LayoutFactory layoutFactory;

    public Repackager(File source) {
        this(source, null);
    }

    public Repackager(File source, LayoutFactory layoutFactory) {
        if (source == null) {
            throw new IllegalArgumentException("Source file must be provided");
        }
        if (!source.exists() || !source.isFile()) {
            throw new IllegalArgumentException("Source must refer to an existing file, got " + source.getAbsolutePath());
        }
        this.source = source.getAbsoluteFile();
        this.layoutFactory = layoutFactory;
    }

    public void addMainClassTimeoutWarningListener(MainClassTimeoutWarningListener listener) {
        this.mainClassTimeoutListeners.add(listener);
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setBackupSource(boolean backupSource) {
        this.backupSource = backupSource;
    }

    public void setLayout(Layout layout) {
        if (layout == null) {
            throw new IllegalArgumentException("Layout must not be null");
        }
        this.layout = layout;
    }

    public void setLayoutFactory(LayoutFactory layoutFactory) {
        this.layoutFactory = layoutFactory;
    }

    public void repackage(Libraries libraries) throws IOException {
        this.repackage(this.source, libraries);
    }

    public void repackage(File destination, Libraries libraries) throws IOException {
        this.repackage(destination, libraries, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repackage(File destination, Libraries libraries, LaunchScript launchScript) throws IOException {
        if (destination == null || destination.isDirectory()) {
            throw new IllegalArgumentException("Invalid destination");
        }
        if (libraries == null) {
            throw new IllegalArgumentException("Libraries must not be null");
        }
        if (this.layout == null) {
            this.layout = this.getLayoutFactory().getLayout(this.source);
        }
        destination = destination.getAbsoluteFile();
        File workingSource = this.source;
        if (this.alreadyRepackaged() && this.source.equals(destination)) {
            return;
        }
        if (this.source.equals(destination)) {
            workingSource = this.getBackupFile();
            workingSource.delete();
            this.renameFile(this.source, workingSource);
        }
        destination.delete();
        try (JarFile jarFileSource = new JarFile(workingSource);){
            this.repackage(jarFileSource, destination, libraries, launchScript);
        }
        finally {
            if (!this.backupSource && !this.source.equals(workingSource)) {
                this.deleteFile(workingSource);
            }
        }
    }

    private LayoutFactory getLayoutFactory() {
        if (this.layoutFactory != null) {
            return this.layoutFactory;
        }
        List factories = SpringFactoriesLoader.loadFactories(LayoutFactory.class, null);
        if (factories.isEmpty()) {
            return new DefaultLayoutFactory();
        }
        Assert.state((factories.size() == 1 ? 1 : 0) != 0, (String)"No unique LayoutFactory found");
        return (LayoutFactory)factories.get(0);
    }

    public final File getBackupFile() {
        return new File(this.source.getParentFile(), this.source.getName() + ".original");
    }

    private boolean alreadyRepackaged() throws IOException {
        try (JarFile jarFile = new JarFile(this.source);){
            Manifest manifest = jarFile.getManifest();
            boolean bl = manifest != null && manifest.getMainAttributes().getValue(BOOT_VERSION_ATTRIBUTE) != null;
            return bl;
        }
    }

    private void repackage(JarFile sourceJar, File destination, Libraries libraries, LaunchScript launchScript) throws IOException {
        WritableLibraries writeableLibraries = new WritableLibraries(libraries);
        try (JarWriter writer = new JarWriter(destination, launchScript);){
            writer.writeManifest(this.buildManifest(sourceJar));
            this.writeLoaderClasses(writer);
            if (this.layout instanceof RepackagingLayout) {
                writer.writeEntries(sourceJar, new RenamingEntryTransformer(((RepackagingLayout)this.layout).getRepackagedClassesLocation()), writeableLibraries);
            } else {
                writer.writeEntries(sourceJar, writeableLibraries);
            }
            writeableLibraries.write(writer);
        }
    }

    private void writeLoaderClasses(JarWriter writer) throws IOException {
        if (this.layout instanceof CustomLoaderLayout) {
            ((CustomLoaderLayout)((Object)this.layout)).writeLoadedClasses(writer);
        } else if (this.layout.isExecutable()) {
            writer.writeLoaderClasses();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isZip(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            boolean bl = this.isZip(fileInputStream);
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private boolean isZip(InputStream inputStream) throws IOException {
        for (int i = 0; i < ZIP_FILE_HEADER.length; ++i) {
            if (inputStream.read() == ZIP_FILE_HEADER[i]) continue;
            return false;
        }
        return true;
    }

    private Manifest buildManifest(JarFile source) throws IOException {
        String launcherClassName;
        Manifest manifest = source.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
            manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        }
        manifest = new Manifest(manifest);
        String startClass = this.mainClass;
        if (startClass == null) {
            startClass = manifest.getMainAttributes().getValue(MAIN_CLASS_ATTRIBUTE);
        }
        if (startClass == null) {
            startClass = this.findMainMethodWithTimeoutWarning(source);
        }
        if ((launcherClassName = this.layout.getLauncherClassName()) != null) {
            manifest.getMainAttributes().putValue(MAIN_CLASS_ATTRIBUTE, launcherClassName);
            if (startClass == null) {
                throw new IllegalStateException("Unable to find main class");
            }
            manifest.getMainAttributes().putValue(START_CLASS_ATTRIBUTE, startClass);
        } else if (startClass != null) {
            manifest.getMainAttributes().putValue(MAIN_CLASS_ATTRIBUTE, startClass);
        }
        String bootVersion = this.getClass().getPackage().getImplementationVersion();
        manifest.getMainAttributes().putValue(BOOT_VERSION_ATTRIBUTE, bootVersion);
        manifest.getMainAttributes().putValue(BOOT_CLASSES_ATTRIBUTE, this.layout instanceof RepackagingLayout ? ((RepackagingLayout)this.layout).getRepackagedClassesLocation() : this.layout.getClassesLocation());
        String lib = this.layout.getLibraryDestination("", LibraryScope.COMPILE);
        if (StringUtils.hasLength((String)lib)) {
            manifest.getMainAttributes().putValue(BOOT_LIB_ATTRIBUTE, lib);
        }
        return manifest;
    }

    private String findMainMethodWithTimeoutWarning(JarFile source) throws IOException {
        long startTime = System.currentTimeMillis();
        String mainMethod = this.findMainMethod(source);
        long duration = System.currentTimeMillis() - startTime;
        if (duration > FIND_WARNING_TIMEOUT) {
            for (MainClassTimeoutWarningListener listener : this.mainClassTimeoutListeners) {
                listener.handleTimeoutWarning(duration, mainMethod);
            }
        }
        return mainMethod;
    }

    protected String findMainMethod(JarFile source) throws IOException {
        return MainClassFinder.findSingleMainClass(source, this.layout.getClassesLocation(), SPRING_BOOT_APPLICATION_CLASS_NAME);
    }

    private void renameFile(File file, File dest) {
        if (!file.renameTo(dest)) {
            throw new IllegalStateException("Unable to rename '" + file + "' to '" + dest + "'");
        }
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            throw new IllegalStateException("Unable to delete '" + file + "'");
        }
    }

    private final class WritableLibraries
    implements JarWriter.UnpackHandler {
        private final Map<String, Library> libraryEntryNames = new LinkedHashMap<String, Library>();

        private WritableLibraries(Libraries libraries) throws IOException {
            libraries.doWithLibraries(library -> {
                Library existing;
                String libraryDestination;
                if (Repackager.this.isZip(library.getFile()) && (libraryDestination = Repackager.this.layout.getLibraryDestination(library.getName(), library.getScope())) != null && (existing = this.libraryEntryNames.putIfAbsent(libraryDestination + library.getName(), library)) != null) {
                    throw new IllegalStateException("Duplicate library " + library.getName());
                }
            });
        }

        @Override
        public boolean requiresUnpack(String name) {
            Library library = this.libraryEntryNames.get(name);
            return library != null && library.isUnpackRequired();
        }

        @Override
        public String sha1Hash(String name) throws IOException {
            Library library = this.libraryEntryNames.get(name);
            if (library == null) {
                throw new IllegalArgumentException("No library found for entry name '" + name + "'");
            }
            return FileUtils.sha1Hash(library.getFile());
        }

        private void write(JarWriter writer) throws IOException {
            for (Map.Entry<String, Library> entry : this.libraryEntryNames.entrySet()) {
                writer.writeNestedLibrary(entry.getKey().substring(0, entry.getKey().lastIndexOf(47) + 1), entry.getValue());
            }
        }
    }

    private static final class RenamingEntryTransformer
    implements JarWriter.EntryTransformer {
        private final String namePrefix;

        private RenamingEntryTransformer(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public JarArchiveEntry transform(JarArchiveEntry entry) {
            if (entry.getName().equals("META-INF/INDEX.LIST")) {
                return null;
            }
            if (entry.getName().startsWith("META-INF/") && !entry.getName().equals("META-INF/aop.xml") && !entry.getName().endsWith(".kotlin-module") || entry.getName().startsWith("BOOT-INF/") || entry.getName().equals("module-info.class")) {
                return entry;
            }
            JarArchiveEntry renamedEntry = new JarArchiveEntry(this.namePrefix + entry.getName());
            renamedEntry.setTime(entry.getTime());
            renamedEntry.setSize(entry.getSize());
            renamedEntry.setMethod(entry.getMethod());
            if (entry.getComment() != null) {
                renamedEntry.setComment(entry.getComment());
            }
            renamedEntry.setCompressedSize(entry.getCompressedSize());
            renamedEntry.setCrc(entry.getCrc());
            if (entry.getCreationTime() != null) {
                renamedEntry.setCreationTime(entry.getCreationTime());
            }
            if (entry.getExtra() != null) {
                renamedEntry.setExtra(entry.getExtra());
            }
            if (entry.getLastAccessTime() != null) {
                renamedEntry.setLastAccessTime(entry.getLastAccessTime());
            }
            if (entry.getLastModifiedTime() != null) {
                renamedEntry.setLastModifiedTime(entry.getLastModifiedTime());
            }
            return renamedEntry;
        }
    }

    @FunctionalInterface
    public static interface MainClassTimeoutWarningListener {
        public void handleTimeoutWarning(long var1, String var3);
    }
}

