/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.springframework.boot.loader.tools.AgentAttacher;
import org.springframework.boot.loader.tools.FileUtils;
import org.springframework.boot.loader.tools.MainClassFinder;

@Mojo(name="run", requiresProject=true, defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class RunMojo
extends AbstractMojo {
    private static final String SPRING_LOADED_AGENT_CLASSNAME = "org.springsource.loaded.agent.SpringLoadedAgent";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="run.addResources", defaultValue="true")
    private boolean addResources;
    @Parameter(property="run.agent")
    private File agent;
    @Parameter(property="run.noverify")
    private Boolean noverify;
    @Parameter(property="run.arguments")
    private String[] arguments;
    @Parameter
    private String mainClass;
    @Parameter
    private String[] folders;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.findAgent();
        if (this.agent != null) {
            this.getLog().info((CharSequence)("Attaching agent: " + this.agent));
            if (this.noverify != null && this.noverify.booleanValue() && !AgentAttacher.hasNoVerify()) {
                throw new MojoExecutionException("The JVM must be started with -noverify for this agent to work. You can use MAVEN_OPTS=-noverify to add that flag.");
            }
            AgentAttacher.attach((File)this.agent);
        }
        String startClassName = this.getStartClass();
        this.run(startClassName);
    }

    private void findAgent() {
        try {
            Class<?> loaded;
            if (this.agent == null && (loaded = Class.forName(SPRING_LOADED_AGENT_CLASSNAME)) != null) {
                CodeSource source;
                if (this.noverify == null) {
                    this.noverify = true;
                }
                if ((source = loaded.getProtectionDomain().getCodeSource()) != null) {
                    this.agent = new File(source.getLocation().getFile());
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void run(String startClassName) throws MojoExecutionException {
        IsolatedThreadGroup threadGroup = new IsolatedThreadGroup(startClassName);
        Thread launchThread = new Thread(threadGroup, new LaunchRunner(startClassName, this.arguments), startClassName + ".main()");
        launchThread.setContextClassLoader(this.getClassLoader());
        launchThread.start();
        this.join(threadGroup);
        threadGroup.rethrowUncaughtException();
    }

    private final String getStartClass() throws MojoExecutionException {
        String mainClass = this.mainClass;
        if (mainClass == null) {
            try {
                mainClass = MainClassFinder.findMainClass((File)this.classesDirectory);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
        if (mainClass == null) {
            throw new MojoExecutionException("Unable to find a suitable main class, please add a 'mainClass' property");
        }
        return mainClass;
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        URL[] urls = this.getClassPathUrls();
        return new URLClassLoader(urls);
    }

    private URL[] getClassPathUrls() throws MojoExecutionException {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            this.addUserDefinedFolders(urls);
            this.addResources(urls);
            this.addProjectClasses(urls);
            this.addDependencies(urls);
            return urls.toArray(new URL[urls.size()]);
        }
        catch (MalformedURLException ex) {
            throw new MojoExecutionException("Unable to build classpath", (Exception)ex);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to build classpath", (Exception)ex);
        }
    }

    private void addUserDefinedFolders(List<URL> urls) throws MalformedURLException {
        if (this.folders != null) {
            for (String folder : this.folders) {
                urls.add(new File(folder).toURI().toURL());
            }
        }
    }

    private void addResources(List<URL> urls) throws MalformedURLException, IOException {
        if (this.addResources) {
            for (Resource resource : this.project.getResources()) {
                File directory = new File(resource.getDirectory());
                urls.add(directory.toURI().toURL());
                FileUtils.removeDuplicatesFromOutputDirectory((File)this.classesDirectory, (File)directory);
            }
        }
    }

    private void addProjectClasses(List<URL> urls) throws MalformedURLException {
        urls.add(this.classesDirectory.toURI().toURL());
    }

    private void addDependencies(List<URL> urls) throws MalformedURLException {
        for (Artifact artifact : this.project.getArtifacts()) {
            if (artifact.getFile() == null || "test".equals(artifact.getScope())) continue;
            urls.add(artifact.getFile().toURI().toURL());
        }
    }

    private void join(ThreadGroup threadGroup) {
        boolean hasNonDaemonThreads;
        do {
            hasNonDaemonThreads = false;
            Thread[] threads = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threads);
            for (Thread thread : threads) {
                if (thread == null || thread.isDaemon()) continue;
                try {
                    hasNonDaemonThreads = true;
                    thread.join();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        } while (hasNonDaemonThreads);
    }

    class LaunchRunner
    implements Runnable {
        private final String startClassName;
        private final String[] args;

        public LaunchRunner(String startClassName, String ... args) {
            this.startClassName = startClassName;
            this.args = args != null ? args : new String[]{};
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            try {
                Class<?> startClass = classLoader.loadClass(this.startClassName);
                Method mainMethod = startClass.getMethod("main", String[].class);
                if (!mainMethod.isAccessible()) {
                    mainMethod.setAccessible(true);
                }
                mainMethod.invoke(null, new Object[]{this.args});
            }
            catch (NoSuchMethodException ex) {
                Exception wrappedEx = new Exception("The specified mainClass doesn't contain a main method with appropriate signature.", ex);
                thread.getThreadGroup().uncaughtException(thread, wrappedEx);
            }
            catch (Exception ex) {
                thread.getThreadGroup().uncaughtException(thread, ex);
            }
        }
    }

    class IsolatedThreadGroup
    extends ThreadGroup {
        private Throwable exception;

        public IsolatedThreadGroup(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            if (!(ex instanceof ThreadDeath)) {
                IsolatedThreadGroup isolatedThreadGroup = this;
                synchronized (isolatedThreadGroup) {
                    this.exception = this.exception == null ? ex : this.exception;
                }
                RunMojo.this.getLog().warn(ex);
            }
        }

        public synchronized void rethrowUncaughtException() throws MojoExecutionException {
            if (this.exception != null) {
                throw new MojoExecutionException("An exception occured while running. " + this.exception.getMessage(), this.exception);
            }
        }
    }
}

