/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.Layouts;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Repackager;
import org.springframework.boot.maven.AbstractDependencyFilterMojo;
import org.springframework.boot.maven.ArtifactsLibraries;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RepackageMojo
extends AbstractDependencyFilterMojo {
    private static final long FIND_WARNING_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter
    private String classifier;
    @Parameter
    private String mainClass;
    @Parameter
    private LayoutType layout;
    @Parameter
    private List<Dependency> requiresUnpack;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().debug((CharSequence)"repackage goal could not be applied to pom project.");
            return;
        }
        File source = this.project.getArtifact().getFile();
        File target = this.getTargetFile();
        Repackager repackager = new Repackager(source){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected String findMainMethod(JarFile source) throws IOException {
                long startTime = System.currentTimeMillis();
                try {
                    String string = super.findMainMethod(source);
                    return string;
                }
                finally {
                    long duration = System.currentTimeMillis() - startTime;
                    if (duration > FIND_WARNING_TIMEOUT) {
                        RepackageMojo.this.getLog().warn((CharSequence)"Searching for the main-class is taking some time, consider using the mainClass configuration parameter");
                    }
                }
            }
        };
        repackager.setMainClass(this.mainClass);
        if (this.layout != null) {
            this.getLog().info((CharSequence)("Layout: " + (Object)((Object)this.layout)));
            repackager.setLayout(this.layout.layout());
        }
        Set<Artifact> artifacts = this.filterDependencies(this.project.getArtifacts(), this.getFilters(new ArtifactsFilter[0]));
        ArtifactsLibraries libraries = new ArtifactsLibraries(artifacts, this.requiresUnpack);
        try {
            repackager.repackage(target, (Libraries)libraries);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        if (!source.equals(target)) {
            this.getLog().info((CharSequence)("Attaching archive: " + target + ", with classifier: " + this.classifier));
            this.projectHelper.attachArtifact(this.project, this.project.getPackaging(), this.classifier, target);
        }
    }

    private File getTargetFile() {
        String classifier;
        String string = classifier = this.classifier == null ? "" : this.classifier.trim();
        if (classifier.length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(this.outputDirectory, this.finalName + classifier + "." + this.project.getPackaging());
    }

    public static enum LayoutType {
        JAR((Layout)new Layouts.Jar()),
        WAR((Layout)new Layouts.War()),
        ZIP((Layout)new Layouts.Expanded()),
        DIR((Layout)new Layouts.Expanded()),
        NONE((Layout)new Layouts.None());

        private final Layout layout;

        public Layout layout() {
            return this.layout;
        }

        private LayoutType(Layout layout) {
            this.layout = layout;
        }
    }
}

