/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.LayoutFactory;
import org.springframework.boot.loader.tools.Layouts;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.LoaderImplementation;
import org.springframework.boot.loader.tools.Packager;
import org.springframework.boot.loader.tools.layer.CustomLayers;
import org.springframework.boot.maven.AbstractDependencyFilterMojo;
import org.springframework.boot.maven.ArtifactsLibraries;
import org.springframework.boot.maven.CustomLayersProvider;
import org.springframework.boot.maven.ExcludeFilter;
import org.springframework.boot.maven.Layers;
import org.springframework.boot.maven.LoggingMainClassTimeoutWarningListener;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class AbstractPackagerMojo
extends AbstractDependencyFilterMojo {
    private static final org.springframework.boot.loader.tools.Layers IMPLICIT_LAYERS = org.springframework.boot.loader.tools.Layers.IMPLICIT;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter
    private String mainClass;
    @Parameter(property="spring-boot.repackage.excludeDevtools", defaultValue="true")
    private boolean excludeDevtools = true;
    @Parameter(property="spring-boot.repackage.excludeDockerCompose", defaultValue="true")
    private boolean excludeDockerCompose = true;
    @Parameter(defaultValue="false")
    public boolean includeSystemScope;
    @Parameter
    private Layers layers;

    protected LayoutType getLayout() {
        return null;
    }

    protected LoaderImplementation getLoaderImplementation() {
        return null;
    }

    protected LayoutFactory getLayoutFactory() {
        return null;
    }

    protected <P extends Packager> P getConfiguredPackager(Supplier<P> supplier) {
        Packager packager = (Packager)supplier.get();
        packager.setLoaderImplementation(this.getLoaderImplementation());
        packager.setLayoutFactory(this.getLayoutFactory());
        packager.addMainClassTimeoutWarningListener((Packager.MainClassTimeoutWarningListener)new LoggingMainClassTimeoutWarningListener(() -> ((AbstractPackagerMojo)this).getLog()));
        packager.setMainClass(this.mainClass);
        LayoutType layout = this.getLayout();
        if (layout != null) {
            this.getLog().info((CharSequence)("Layout: " + layout));
            packager.setLayout(layout.layout());
        }
        if (this.layers == null) {
            packager.setLayers(IMPLICIT_LAYERS);
        } else if (this.layers.isEnabled()) {
            packager.setLayers((org.springframework.boot.loader.tools.Layers)(this.layers.getConfiguration() != null ? this.getCustomLayers(this.layers.getConfiguration()) : IMPLICIT_LAYERS));
            packager.setIncludeRelevantJarModeJars(this.layers.isIncludeLayerTools());
        }
        return (P)packager;
    }

    private CustomLayers getCustomLayers(File configuration) {
        try {
            Document document = this.getDocumentIfAvailable(configuration);
            return new CustomLayersProvider().getLayers(document);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to process custom layers configuration " + configuration.getAbsolutePath(), ex);
        }
    }

    private Document getDocumentIfAvailable(File xmlFile) throws Exception {
        InputSource inputSource = new InputSource(new FileInputStream(xmlFile));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(inputSource);
    }

    protected final Libraries getLibraries(Collection<Dependency> unpacks) throws MojoExecutionException {
        Set artifacts = this.project.getArtifacts();
        Set<Artifact> includedArtifacts = this.filterDependencies(artifacts, this.getAdditionalFilters());
        return new ArtifactsLibraries(artifacts, includedArtifacts, this.session.getProjects(), unpacks, this.getLog());
    }

    private ArtifactsFilter[] getAdditionalFilters() {
        ArrayList<ExcludeFilter> filters = new ArrayList<ExcludeFilter>();
        if (this.excludeDevtools) {
            filters.add(DEVTOOLS_EXCLUDE_FILTER);
        }
        if (this.excludeDockerCompose) {
            filters.add(DOCKER_COMPOSE_EXCLUDE_FILTER);
        }
        if (!this.includeSystemScope) {
            filters.add((ExcludeFilter)new ScopeFilter(null, "system"));
        }
        return filters.toArray(new ArtifactsFilter[0]);
    }

    protected Artifact getSourceArtifact(String classifier) {
        Artifact sourceArtifact = this.getArtifact(classifier);
        return sourceArtifact != null ? sourceArtifact : this.project.getArtifact();
    }

    private Artifact getArtifact(String classifier) {
        if (classifier != null) {
            for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
                if (!classifier.equals(attachedArtifact.getClassifier()) || attachedArtifact.getFile() == null || !attachedArtifact.getFile().isFile()) continue;
                return attachedArtifact;
            }
        }
        return null;
    }

    protected File getTargetFile(String finalName, String classifier, File targetDirectory) {
        Object classifierSuffix;
        Object object = classifierSuffix = classifier != null ? classifier.trim() : "";
        if (!((String)classifierSuffix).isEmpty() && !((String)classifierSuffix).startsWith("-")) {
            classifierSuffix = "-" + (String)classifierSuffix;
        }
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        return new File(targetDirectory, finalName + (String)classifierSuffix + "." + this.project.getArtifact().getArtifactHandler().getExtension());
    }

    public static enum LayoutType {
        JAR((Layout)new Layouts.Jar()),
        WAR((Layout)new Layouts.War()),
        ZIP((Layout)new Layouts.Expanded()),
        DIR((Layout)new Layouts.Expanded()),
        NONE((Layout)new Layouts.None());

        private final Layout layout;

        private LayoutType(Layout layout) {
            this.layout = layout;
        }

        public Layout layout() {
            return this.layout;
        }
    }
}

