/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.layer.ApplicationContentFilter;
import org.springframework.boot.loader.tools.layer.ContentFilter;
import org.springframework.boot.loader.tools.layer.ContentSelector;
import org.springframework.boot.loader.tools.layer.CustomLayers;
import org.springframework.boot.loader.tools.layer.IncludeExcludeContentSelector;
import org.springframework.boot.loader.tools.layer.LibraryContentFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class CustomLayersProvider {
    CustomLayersProvider() {
    }

    CustomLayers getLayers(Document document) {
        this.validate(document);
        Element root = document.getDocumentElement();
        List<ContentSelector<String>> applicationSelectors = this.getApplicationSelectors(root);
        List<ContentSelector<Library>> librarySelectors = this.getLibrarySelectors(root);
        List<Layer> layers = this.getLayers(root);
        return new CustomLayers(layers, applicationSelectors, librarySelectors);
    }

    private void validate(Document document) {
        Schema schema = this.loadSchema();
        try {
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(document));
        }
        catch (IOException | SAXException ex) {
            throw new IllegalStateException("Invalid layers.xml configuration", ex);
        }
    }

    private Schema loadSchema() {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            return factory.newSchema(this.getClass().getResource("layers.xsd"));
        }
        catch (SAXException ex) {
            throw new IllegalStateException("Unable to load layers XSD");
        }
    }

    private List<ContentSelector<String>> getApplicationSelectors(Element root) {
        return this.getSelectors(root, "application", element -> this.getSelector((Element)element, ApplicationContentFilter::new));
    }

    private List<ContentSelector<Library>> getLibrarySelectors(Element root) {
        return this.getSelectors(root, "dependencies", element -> this.getLibrarySelector((Element)element, LibraryContentFilter::new));
    }

    private List<Layer> getLayers(Element root) {
        Element layerOrder = this.getChildElement(root, "layerOrder");
        if (layerOrder == null) {
            return Collections.emptyList();
        }
        return this.getChildNodeTextContent(layerOrder, "layer").stream().map(Layer::new).toList();
    }

    private <T> List<ContentSelector<T>> getSelectors(Element root, String elementName, Function<Element, ContentSelector<T>> selectorFactory) {
        Element element = this.getChildElement(root, elementName);
        if (element == null) {
            return Collections.emptyList();
        }
        ArrayList<ContentSelector<T>> selectors = new ArrayList<ContentSelector<T>>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            ContentSelector<T> selector = selectorFactory.apply(childElement);
            selectors.add(selector);
        }
        return selectors;
    }

    private <T> ContentSelector<T> getSelector(Element element, Function<String, ContentFilter<T>> filterFactory) {
        Layer layer = new Layer(element.getAttribute("layer"));
        List<String> includes = this.getChildNodeTextContent(element, "include");
        List<String> excludes = this.getChildNodeTextContent(element, "exclude");
        return new IncludeExcludeContentSelector(layer, includes, excludes, filterFactory);
    }

    private ContentSelector<Library> getLibrarySelector(Element element, Function<String, ContentFilter<Library>> filterFactory) {
        Layer layer = new Layer(element.getAttribute("layer"));
        List<String> includes = this.getChildNodeTextContent(element, "include");
        List<String> excludes = this.getChildNodeTextContent(element, "exclude");
        Element includeModuleDependencies = this.getChildElement(element, "includeModuleDependencies");
        Element excludeModuleDependencies = this.getChildElement(element, "excludeModuleDependencies");
        List includeFilters = includes.stream().map(filterFactory).collect(Collectors.toCollection(ArrayList::new));
        if (includeModuleDependencies != null) {
            includeFilters.add(Library::isLocal);
        }
        List excludeFilters = excludes.stream().map(filterFactory).collect(Collectors.toCollection(ArrayList::new));
        if (excludeModuleDependencies != null) {
            excludeFilters.add(Library::isLocal);
        }
        return new IncludeExcludeContentSelector(layer, includeFilters, excludeFilters);
    }

    private List<String> getChildNodeTextContent(Element element, String tagName) {
        ArrayList<String> patterns = new ArrayList<String>();
        NodeList nodes = element.getElementsByTagName(tagName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            patterns.add(node.getTextContent());
        }
        return patterns;
    }

    private Element getChildElement(Element element, String tagName) {
        NodeList nodes = element.getElementsByTagName(tagName);
        if (nodes.getLength() == 0) {
            return null;
        }
        if (nodes.getLength() > 1) {
            throw new IllegalStateException("Multiple '" + tagName + "' nodes found");
        }
        return (Element)nodes.item(0);
    }
}

