/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

class EnvVariables {
    private final Map<String, String> variables;

    EnvVariables(@Nullable Map<String, String> variables) {
        this.variables = EnvVariables.parseEnvVariables(variables);
    }

    private static Map<String, String> parseEnvVariables(@Nullable Map<String, String> args) {
        if (args == null || args.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> e : args.entrySet()) {
            if (e.getKey() == null) continue;
            result.put(e.getKey(), EnvVariables.getValue(e.getValue()));
        }
        return result;
    }

    private static String getValue(@Nullable String value) {
        return value != null ? value : "";
    }

    Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.variables);
    }

    String[] asArray() {
        ArrayList<CallSite> args = new ArrayList<CallSite>(this.variables.size());
        for (Map.Entry<String, String> arg : this.variables.entrySet()) {
            args.add((CallSite)((Object)(arg.getKey() + "=" + arg.getValue())));
        }
        return args.toArray(new String[0]);
    }
}

