/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.migrator;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.boot.context.properties.migrator.PropertiesMigrationReport;
import org.springframework.boot.context.properties.migrator.PropertyMigration;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

class PropertiesMigrationReporter {
    private final Map<String, ConfigurationMetadataProperty> allProperties;
    private final ConfigurableEnvironment environment;

    PropertiesMigrationReporter(ConfigurationMetadataRepository metadataRepository, ConfigurableEnvironment environment) {
        this.allProperties = Collections.unmodifiableMap(metadataRepository.getAllProperties());
        this.environment = environment;
    }

    PropertiesMigrationReport getReport() {
        PropertiesMigrationReport report = new PropertiesMigrationReport();
        Map<String, List<PropertyMigration>> properties = this.getMatchingProperties(ConfigurationMetadataProperty::isDeprecated);
        if (properties.isEmpty()) {
            return report;
        }
        properties.forEach((name, candidates) -> {
            PropertySource<?> propertySource = this.mapPropertiesWithReplacement(report, (String)name, (List<PropertyMigration>)candidates);
            if (propertySource != null) {
                this.environment.getPropertySources().addBefore(name, propertySource);
            }
        });
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertySource<?> mapPropertiesWithReplacement(PropertiesMigrationReport report, String name, List<PropertyMigration> properties) {
        report.add(name, properties);
        List<PropertyMigration> renamed = properties.stream().filter(PropertyMigration::isCompatibleType).toList();
        if (renamed.isEmpty()) {
            return null;
        }
        NameTrackingPropertySource nameTrackingPropertySource = new NameTrackingPropertySource();
        this.environment.getPropertySources().addFirst((PropertySource)nameTrackingPropertySource);
        try {
            String target = "migrate-" + name;
            LinkedHashMap<String, OriginTrackedValue> content = new LinkedHashMap<String, OriginTrackedValue>();
            for (PropertyMigration candidate : renamed) {
                String newPropertyName = candidate.getNewPropertyName();
                Object value = candidate.getProperty().getValue();
                if (nameTrackingPropertySource.isPlaceholderThatAccessesName(value, newPropertyName)) continue;
                OriginTrackedValue originTrackedValue = OriginTrackedValue.of((Object)value, (Origin)candidate.getProperty().getOrigin());
                content.put(newPropertyName, originTrackedValue);
            }
            OriginTrackedMapPropertySource originTrackedMapPropertySource = new OriginTrackedMapPropertySource(target, content);
            return originTrackedMapPropertySource;
        }
        finally {
            this.environment.getPropertySources().remove(nameTrackingPropertySource.getName());
        }
    }

    private boolean isMapType(ConfigurationMetadataProperty property) {
        String type = property.getType();
        return type != null && type.startsWith(Map.class.getName());
    }

    private Map<String, List<PropertyMigration>> getMatchingProperties(Predicate<ConfigurationMetadataProperty> filter) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        List<ConfigurationMetadataProperty> candidates = this.allProperties.values().stream().filter(filter).toList();
        this.getPropertySourcesAsMap().forEach((arg_0, arg_1) -> this.lambda$getMatchingProperties$3(candidates, (MultiValueMap)result, arg_0, arg_1));
        return result;
    }

    private ConfigurationMetadataProperty determineReplacementMetadata(ConfigurationMetadataProperty metadata) {
        String replacementId = metadata.getDeprecation().getReplacement();
        if (StringUtils.hasText((String)replacementId)) {
            ConfigurationMetadataProperty replacement = this.allProperties.get(replacementId);
            if (replacement != null) {
                return replacement;
            }
            return this.detectMapValueReplacement(replacementId);
        }
        return null;
    }

    private ConfigurationMetadataProperty detectMapValueReplacement(String fullId) {
        int lastDot = fullId.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        ConfigurationMetadataProperty metadata = this.allProperties.get(fullId.substring(0, lastDot));
        if (metadata != null && this.isMapType(metadata)) {
            return metadata;
        }
        return null;
    }

    private Map<String, ConfigurationPropertySource> getPropertySourcesAsMap() {
        LinkedHashMap<String, ConfigurationPropertySource> map = new LinkedHashMap<String, ConfigurationPropertySource>();
        for (ConfigurationPropertySource source : ConfigurationPropertySources.get((Environment)this.environment)) {
            map.put(this.determinePropertySourceName(source), source);
        }
        return map;
    }

    private String determinePropertySourceName(ConfigurationPropertySource source) {
        if (source.getUnderlyingSource() instanceof PropertySource) {
            return ((PropertySource)source.getUnderlyingSource()).getName();
        }
        return source.getUnderlyingSource().toString();
    }

    private /* synthetic */ void lambda$getMatchingProperties$3(List candidates, MultiValueMap result, String propertySourceName, ConfigurationPropertySource propertySource) {
        candidates.forEach(metadata -> {
            ConfigurationPropertyName metadataName = ConfigurationPropertyName.isValid((CharSequence)metadata.getId()) ? ConfigurationPropertyName.of((CharSequence)metadata.getId()) : ConfigurationPropertyName.adapt((CharSequence)metadata.getId(), (char)'.');
            ConfigurationProperty match = propertySource.getConfigurationProperty(metadataName);
            if (match != null) {
                result.add((Object)propertySourceName, (Object)new PropertyMigration(match, (ConfigurationMetadataProperty)metadata, this.determineReplacementMetadata((ConfigurationMetadataProperty)metadata), false));
            }
            if (this.isMapType((ConfigurationMetadataProperty)metadata) && propertySource instanceof IterableConfigurationPropertySource) {
                IterableConfigurationPropertySource iterableSource = (IterableConfigurationPropertySource)propertySource;
                iterableSource.stream().filter(arg_0 -> ((ConfigurationPropertyName)metadataName).isAncestorOf(arg_0)).map(arg_0 -> ((ConfigurationPropertySource)propertySource).getConfigurationProperty(arg_0)).forEach(property -> {
                    ConfigurationMetadataProperty replacement = this.determineReplacementMetadata((ConfigurationMetadataProperty)metadata);
                    result.add((Object)propertySourceName, (Object)new PropertyMigration((ConfigurationProperty)property, (ConfigurationMetadataProperty)metadata, replacement, true));
                });
            }
        });
    }

    private class NameTrackingPropertySource
    extends PropertySource<Object> {
        private final Set<String> accessedNames;

        NameTrackingPropertySource() {
            super(NameTrackingPropertySource.class.getName());
            this.accessedNames = new HashSet<String>();
        }

        boolean isPlaceholderThatAccessesName(Object value, String name) {
            if (value instanceof String) {
                this.accessedNames.clear();
                PropertiesMigrationReporter.this.environment.resolvePlaceholders((String)value);
                return this.accessedNames.contains(name);
            }
            return false;
        }

        public Object getProperty(String name) {
            this.accessedNames.add(name);
            return null;
        }
    }
}

