/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.testcontainers;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.r2dbc.autoconfigure.R2dbcConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.containers.OracleR2DBCDatabaseContainer;

class OracleXeR2dbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<OracleContainer, R2dbcConnectionDetails> {
    OracleXeR2dbcContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[]{"io.r2dbc.spi.ConnectionFactoryOptions"});
    }

    public R2dbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<OracleContainer> source) {
        return new R2dbcDatabaseContainerConnectionDetails(source);
    }

    private static final class R2dbcDatabaseContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<OracleContainer>
    implements R2dbcConnectionDetails {
        private R2dbcDatabaseContainerConnectionDetails(ContainerConnectionSource<OracleContainer> source) {
            super(source);
        }

        @Override
        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return OracleR2DBCDatabaseContainer.getOptions((OracleContainer)((OracleContainer)this.getContainer()));
        }
    }
}

