/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.rsocket.netty;

import io.netty.handler.ssl.ClientAuth;
import io.rsocket.SocketAcceptor;
import io.rsocket.core.RSocketServer;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.server.CloseableChannel;
import io.rsocket.transport.netty.server.TcpServerTransport;
import io.rsocket.transport.netty.server.WebsocketServerTransport;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.rsocket.netty.NettyRSocketServer;
import org.springframework.boot.rsocket.server.ConfigurableRSocketServerFactory;
import org.springframework.boot.rsocket.server.RSocketServer;
import org.springframework.boot.rsocket.server.RSocketServerCustomizer;
import org.springframework.boot.rsocket.server.RSocketServerFactory;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServerSslBundle;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;
import reactor.core.publisher.Mono;
import reactor.netty.http.Http11SslContextSpec;
import reactor.netty.http.server.HttpServer;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpServer;

public class NettyRSocketServerFactory
implements RSocketServerFactory,
ConfigurableRSocketServerFactory {
    private int port = 9898;
    private @Nullable DataSize fragmentSize;
    private @Nullable InetAddress address;
    private RSocketServer.Transport transport = RSocketServer.Transport.TCP;
    private @Nullable ReactorResourceFactory resourceFactory;
    private @Nullable Duration lifecycleTimeout;
    private List<RSocketServerCustomizer> rSocketServerCustomizers = new ArrayList<RSocketServerCustomizer>();
    private @Nullable Ssl ssl;
    private @Nullable SslBundles sslBundles;

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void setFragmentSize(@Nullable DataSize fragmentSize) {
        this.fragmentSize = fragmentSize;
    }

    @Override
    public void setAddress(@Nullable InetAddress address) {
        this.address = address;
    }

    @Override
    public void setTransport(RSocketServer.Transport transport) {
        this.transport = transport;
    }

    @Override
    public void setSsl(@Nullable Ssl ssl) {
        this.ssl = ssl;
    }

    @Override
    public void setSslBundles(@Nullable SslBundles sslBundles) {
        this.sslBundles = sslBundles;
    }

    public void setResourceFactory(@Nullable ReactorResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public void setRSocketServerCustomizers(Collection<? extends RSocketServerCustomizer> rSocketServerCustomizers) {
        Assert.notNull(rSocketServerCustomizers, (String)"'rSocketServerCustomizers' must not be null");
        this.rSocketServerCustomizers = new ArrayList<RSocketServerCustomizer>(rSocketServerCustomizers);
    }

    public void addRSocketServerCustomizers(RSocketServerCustomizer ... rSocketServerCustomizers) {
        Assert.notNull((Object)rSocketServerCustomizers, (String)"'rSocketServerCustomizers' must not be null");
        this.rSocketServerCustomizers.addAll(Arrays.asList(rSocketServerCustomizers));
    }

    public void setLifecycleTimeout(Duration lifecycleTimeout) {
        this.lifecycleTimeout = lifecycleTimeout;
    }

    @Override
    public NettyRSocketServer create(SocketAcceptor socketAcceptor) {
        ServerTransport<CloseableChannel> transport = this.createTransport();
        RSocketServer server = RSocketServer.create((SocketAcceptor)socketAcceptor);
        this.configureServer(server);
        Mono starter = server.bind(transport);
        return new NettyRSocketServer((Mono<CloseableChannel>)starter, this.lifecycleTimeout);
    }

    private void configureServer(RSocketServer server) {
        PropertyMapper map = PropertyMapper.get();
        map.from((Object)this.fragmentSize).asInt(DataSize::toBytes).to(arg_0 -> ((RSocketServer)server).fragment(arg_0));
        this.rSocketServerCustomizers.forEach(customizer -> customizer.customize(server));
    }

    private ServerTransport<CloseableChannel> createTransport() {
        if (this.transport == RSocketServer.Transport.WEBSOCKET) {
            return this.createWebSocketTransport();
        }
        return this.createTcpTransport();
    }

    private ServerTransport<CloseableChannel> createWebSocketTransport() {
        HttpServer httpServer = HttpServer.create();
        if (this.resourceFactory != null) {
            httpServer = (HttpServer)httpServer.runOn(this.resourceFactory.getLoopResources());
        }
        if (Ssl.isEnabled((Ssl)this.ssl)) {
            httpServer = this.customizeSslConfiguration(httpServer, this.ssl);
        }
        return WebsocketServerTransport.create((HttpServer)httpServer.bindAddress(this::getListenAddress));
    }

    private HttpServer customizeSslConfiguration(HttpServer httpServer, Ssl ssl) {
        return new HttpServerSslCustomizer(ssl.getClientAuth(), this.getSslBundle(), this.getServerNameSslBundles()).apply(httpServer);
    }

    private ServerTransport<CloseableChannel> createTcpTransport() {
        TcpServer tcpServer = TcpServer.create();
        if (this.resourceFactory != null) {
            tcpServer = tcpServer.runOn(this.resourceFactory.getLoopResources());
        }
        if (Ssl.isEnabled((Ssl)this.ssl)) {
            tcpServer = new TcpServerSslCustomizer(this.ssl.getClientAuth(), this.getSslBundle(), this.getServerNameSslBundles()).apply(tcpServer);
        }
        return TcpServerTransport.create((TcpServer)tcpServer.bindAddress(this::getListenAddress));
    }

    private SslBundle getSslBundle() {
        return WebServerSslBundle.get((Ssl)this.ssl, (SslBundles)this.sslBundles);
    }

    protected final Map<String, SslBundle> getServerNameSslBundles() {
        Assert.state((this.ssl != null ? 1 : 0) != 0, (String)"'ssl' must not be null");
        return this.ssl.getServerNameBundles().stream().collect(Collectors.toMap(Ssl.ServerNameSslBundle::serverName, this::getBundle));
    }

    private SslBundle getBundle(Ssl.ServerNameSslBundle serverNameSslBundle) {
        Assert.state((this.sslBundles != null ? 1 : 0) != 0, (String)"'sslBundles' must not be null");
        return this.sslBundles.getBundle(serverNameSslBundle.bundle());
    }

    private InetSocketAddress getListenAddress() {
        if (this.address != null) {
            return new InetSocketAddress(this.address.getHostAddress(), this.port);
        }
        return new InetSocketAddress(this.port);
    }

    private static final class HttpServerSslCustomizer
    extends SslCustomizer {
        private final SslProvider sslProvider;
        private final Map<String, SslProvider> serverNameSslProviders;

        private HttpServerSslCustomizer(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Ssl.ClientAuth clientAuth, SslBundle sslBundle, Map<String, SslBundle> serverNameSslBundles) {
            super((ClientAuth)Ssl.ClientAuth.map((Ssl.ClientAuth)clientAuth, (Object)ClientAuth.NONE, (Object)ClientAuth.OPTIONAL, (Object)ClientAuth.REQUIRE));
            this.sslProvider = this.createSslProvider(sslBundle);
            this.serverNameSslProviders = this.createServerNameSslProviders(serverNameSslBundles);
        }

        private HttpServer apply(HttpServer server) {
            return server.secure(this::applySecurity);
        }

        private void applySecurity(SslProvider.SslContextSpec spec) {
            spec.sslContext(this.sslProvider.getSslContext()).setSniAsyncMappings((serverName, promise) -> {
                SslProvider provider = serverName != null ? this.serverNameSslProviders.get(serverName) : this.sslProvider;
                return promise.setSuccess((Object)provider);
            });
        }

        private Map<String, SslProvider> createServerNameSslProviders(Map<String, SslBundle> serverNameSslBundles) {
            HashMap<String, SslProvider> serverNameSslProviders = new HashMap<String, SslProvider>();
            serverNameSslBundles.forEach((serverName, sslBundle) -> serverNameSslProviders.put((String)serverName, this.createSslProvider((SslBundle)sslBundle)));
            return serverNameSslProviders;
        }

        private SslProvider createSslProvider(SslBundle sslBundle) {
            return SslProvider.builder().sslContext(this.createSslContextSpec(sslBundle)).build();
        }
    }

    private static final class TcpServerSslCustomizer
    extends SslCustomizer {
        private final SslBundle sslBundle;

        private TcpServerSslCustomizer(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Ssl.ClientAuth clientAuth, SslBundle sslBundle, Map<String, SslBundle> serverNameSslBundles) {
            super((ClientAuth)Ssl.ClientAuth.map((Ssl.ClientAuth)clientAuth, (Object)ClientAuth.NONE, (Object)ClientAuth.OPTIONAL, (Object)ClientAuth.REQUIRE));
            this.sslBundle = sslBundle;
        }

        private TcpServer apply(TcpServer server) {
            AbstractProtocolSslContextSpec<?> sslContextSpec = this.createSslContextSpec(this.sslBundle);
            return server.secure(spec -> spec.sslContext(sslContextSpec));
        }
    }

    private static abstract class SslCustomizer {
        private final ClientAuth clientAuth;

        protected SslCustomizer(ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
        }

        protected final AbstractProtocolSslContextSpec<?> createSslContextSpec(SslBundle sslBundle) {
            Http11SslContextSpec sslContextSpec = Http11SslContextSpec.forServer((KeyManagerFactory)sslBundle.getManagers().getKeyManagerFactory());
            return sslContextSpec.configure(builder -> {
                builder.trustManager(sslBundle.getManagers().getTrustManagerFactory());
                SslOptions options = sslBundle.getOptions();
                builder.protocols(options.getEnabledProtocols());
                builder.ciphers((Iterable)SslOptions.asSet((String[])options.getCiphers()));
                builder.clientAuth(this.clientAuth);
            });
        }
    }
}

