/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.autoconfigure.actuate.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.security.autoconfigure.actuate.servlet.RequestMatcherProvider;
import org.springframework.boot.security.servlet.ApplicationContextRequestMatcher;
import org.springframework.boot.web.server.context.WebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public final class EndpointRequest {
    private static final RequestMatcher EMPTY_MATCHER = request -> false;

    private EndpointRequest() {
    }

    public static EndpointRequestMatcher toAnyEndpoint() {
        return new EndpointRequestMatcher(true);
    }

    public static EndpointRequestMatcher to(Class<?> ... endpoints) {
        return new EndpointRequestMatcher(endpoints, false);
    }

    public static EndpointRequestMatcher to(String ... endpoints) {
        return new EndpointRequestMatcher(endpoints, false);
    }

    public static LinksRequestMatcher toLinks() {
        return new LinksRequestMatcher();
    }

    public static AdditionalPathsEndpointRequestMatcher toAdditionalPaths(WebServerNamespace webServerNamespace, Class<?> ... endpoints) {
        return new AdditionalPathsEndpointRequestMatcher(webServerNamespace, endpoints);
    }

    public static AdditionalPathsEndpointRequestMatcher toAdditionalPaths(WebServerNamespace webServerNamespace, String ... endpoints) {
        return new AdditionalPathsEndpointRequestMatcher(webServerNamespace, endpoints);
    }

    public static final class EndpointRequestMatcher
    extends AbstractRequestMatcher {
        private final List<Object> includes;
        private final List<Object> excludes;
        private final boolean includeLinks;
        private final @Nullable HttpMethod httpMethod;

        private EndpointRequestMatcher(boolean includeLinks) {
            this(Collections.emptyList(), Collections.emptyList(), includeLinks, null);
        }

        private EndpointRequestMatcher(Class<?>[] endpoints, boolean includeLinks) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList(), includeLinks, null);
        }

        private EndpointRequestMatcher(String[] endpoints, boolean includeLinks) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList(), includeLinks, null);
        }

        private EndpointRequestMatcher(List<Object> includes, List<Object> excludes, boolean includeLinks, @Nullable HttpMethod httpMethod) {
            this.includes = includes;
            this.excludes = excludes;
            this.includeLinks = includeLinks;
            this.httpMethod = httpMethod;
        }

        public EndpointRequestMatcher excluding(Class<?> ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointRequestMatcher(this.includes, excludes, this.includeLinks, null);
        }

        public EndpointRequestMatcher excluding(String ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointRequestMatcher(this.includes, excludes, this.includeLinks, null);
        }

        public EndpointRequestMatcher excludingLinks() {
            return new EndpointRequestMatcher(this.includes, this.excludes, false, null);
        }

        public EndpointRequestMatcher withHttpMethod(HttpMethod httpMethod) {
            return new EndpointRequestMatcher(this.includes, this.excludes, this.includeLinks, httpMethod);
        }

        @Override
        protected RequestMatcher createDelegate(WebApplicationContext context, RequestMatcherFactory requestMatcherFactory) {
            PathMappedEndpoints endpoints = (PathMappedEndpoints)context.getBean(PathMappedEndpoints.class);
            RequestMatcherProvider matcherProvider = this.getRequestMatcherProvider(context);
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            if (this.includes.isEmpty()) {
                paths.addAll(endpoints.getAllPaths());
            }
            this.streamPaths(this.includes, endpoints).forEach(paths::add);
            this.streamPaths(this.excludes, endpoints).forEach(paths::remove);
            List<RequestMatcher> delegateMatchers = this.getDelegateMatchers(requestMatcherFactory, matcherProvider, paths, this.httpMethod);
            String basePath = endpoints.getBasePath();
            if (this.includeLinks && StringUtils.hasText((String)basePath)) {
                delegateMatchers.addAll(this.getLinksMatchers(requestMatcherFactory, matcherProvider, basePath));
            }
            if (delegateMatchers.isEmpty()) {
                return EMPTY_MATCHER;
            }
            return new OrRequestMatcher(delegateMatchers);
        }

        private Stream<String> streamPaths(List<Object> source, PathMappedEndpoints endpoints) {
            return source.stream().filter(Objects::nonNull).map(this::getEndpointId).map(arg_0 -> ((PathMappedEndpoints)endpoints).getPath(arg_0)).filter(Objects::nonNull);
        }

        public String toString() {
            return String.format("EndpointRequestMatcher includes=%s, excludes=%s, includeLinks=%s", this.toString(this.includes, "[*]"), this.toString(this.excludes, "[]"), this.includeLinks);
        }
    }

    public static final class LinksRequestMatcher
    extends AbstractRequestMatcher {
        @Override
        protected RequestMatcher createDelegate(WebApplicationContext context, RequestMatcherFactory requestMatcherFactory) {
            WebEndpointProperties properties = (WebEndpointProperties)context.getBean(WebEndpointProperties.class);
            String basePath = properties.getBasePath();
            if (StringUtils.hasText((String)basePath)) {
                return new OrRequestMatcher(this.getLinksMatchers(requestMatcherFactory, this.getRequestMatcherProvider(context), basePath));
            }
            return EMPTY_MATCHER;
        }

        public String toString() {
            return String.format("LinksRequestMatcher", new Object[0]);
        }
    }

    public static class AdditionalPathsEndpointRequestMatcher
    extends AbstractRequestMatcher {
        private final WebServerNamespace webServerNamespace;
        private final List<Object> endpoints;
        private final @Nullable HttpMethod httpMethod;

        AdditionalPathsEndpointRequestMatcher(WebServerNamespace webServerNamespace, String ... endpoints) {
            this(webServerNamespace, Arrays.asList((Object[])endpoints), null);
        }

        AdditionalPathsEndpointRequestMatcher(WebServerNamespace webServerNamespace, Class<?> ... endpoints) {
            this(webServerNamespace, Arrays.asList((Object[])endpoints), null);
        }

        private AdditionalPathsEndpointRequestMatcher(WebServerNamespace webServerNamespace, List<Object> endpoints, @Nullable HttpMethod httpMethod) {
            Assert.notNull((Object)webServerNamespace, (String)"'webServerNamespace' must not be null");
            Assert.notNull(endpoints, (String)"'endpoints' must not be null");
            Assert.notEmpty(endpoints, (String)"'endpoints' must not be empty");
            this.webServerNamespace = webServerNamespace;
            this.endpoints = endpoints;
            this.httpMethod = httpMethod;
        }

        public AdditionalPathsEndpointRequestMatcher withHttpMethod(HttpMethod httpMethod) {
            return new AdditionalPathsEndpointRequestMatcher(this.webServerNamespace, this.endpoints, httpMethod);
        }

        @Override
        protected boolean ignoreApplicationContext(WebApplicationContext applicationContext, ManagementPortType managementPortType) {
            return !this.hasWebServerNamespace((ApplicationContext)applicationContext, this.webServerNamespace);
        }

        @Override
        protected RequestMatcher createDelegate(WebApplicationContext context, RequestMatcherFactory requestMatcherFactory) {
            Set paths;
            PathMappedEndpoints endpoints = (PathMappedEndpoints)context.getBean(PathMappedEndpoints.class);
            RequestMatcherProvider matcherProvider = this.getRequestMatcherProvider(context);
            List<RequestMatcher> delegateMatchers = this.getDelegateMatchers(requestMatcherFactory, matcherProvider, paths = (Set)this.endpoints.stream().filter(Objects::nonNull).map(this::getEndpointId).flatMap(endpointId -> this.streamAdditionalPaths(endpoints, (EndpointId)endpointId)).collect(Collectors.toCollection(LinkedHashSet::new)), this.httpMethod);
            return !CollectionUtils.isEmpty(delegateMatchers) ? new OrRequestMatcher(delegateMatchers) : EMPTY_MATCHER;
        }

        private Stream<String> streamAdditionalPaths(PathMappedEndpoints pathMappedEndpoints, EndpointId endpointId) {
            return pathMappedEndpoints.getAdditionalPaths(this.webServerNamespace, endpointId).stream();
        }

        public String toString() {
            return String.format("AdditionalPathsEndpointRequestMatcher endpoints=%s, webServerNamespace=%s", this.toString(this.endpoints, ""), this.webServerNamespace);
        }
    }

    private static final class RequestMatcherFactory {
        private RequestMatcherFactory() {
        }

        RequestMatcher antPath(RequestMatcherProvider matcherProvider, @Nullable HttpMethod httpMethod, String ... parts) {
            StringBuilder pattern = new StringBuilder();
            for (String part : parts) {
                Assert.notNull((Object)part, (String)"'part' must not be null");
                pattern.append(part);
            }
            return matcherProvider.getRequestMatcher(pattern.toString(), httpMethod);
        }
    }

    private static abstract class AbstractRequestMatcher
    extends ApplicationContextRequestMatcher<WebApplicationContext> {
        private volatile @Nullable RequestMatcher delegate;
        private volatile @Nullable ManagementPortType managementPortType;

        AbstractRequestMatcher() {
            super(WebApplicationContext.class);
        }

        @Override
        protected boolean ignoreApplicationContext(WebApplicationContext applicationContext) {
            ManagementPortType managementPortType = this.managementPortType;
            if (managementPortType == null) {
                this.managementPortType = managementPortType = ManagementPortType.get((Environment)applicationContext.getEnvironment());
            }
            return this.ignoreApplicationContext(applicationContext, managementPortType);
        }

        protected boolean ignoreApplicationContext(WebApplicationContext applicationContext, ManagementPortType managementPortType) {
            return managementPortType == ManagementPortType.DIFFERENT && !this.hasWebServerNamespace((ApplicationContext)applicationContext, WebServerNamespace.MANAGEMENT);
        }

        protected final boolean hasWebServerNamespace(ApplicationContext applicationContext, WebServerNamespace webServerNamespace) {
            return WebServerApplicationContext.hasServerNamespace((ApplicationContext)applicationContext, (String)webServerNamespace.getValue()) || this.hasImplicitServerNamespace(applicationContext, webServerNamespace);
        }

        private boolean hasImplicitServerNamespace(ApplicationContext applicationContext, WebServerNamespace webServerNamespace) {
            return WebServerNamespace.SERVER.equals((Object)webServerNamespace) && WebServerApplicationContext.getServerNamespace((ApplicationContext)applicationContext) == null && applicationContext.getParent() == null;
        }

        @Override
        protected final void initialized(Supplier<WebApplicationContext> context) {
            this.delegate = this.createDelegate(context.get());
        }

        @Override
        protected final boolean matches(HttpServletRequest request, Supplier<WebApplicationContext> context) {
            RequestMatcher delegate = this.delegate;
            Assert.state((delegate != null ? 1 : 0) != 0, (String)"'delegate' must not be null");
            return delegate.matches(request);
        }

        private RequestMatcher createDelegate(WebApplicationContext context) {
            try {
                return this.createDelegate(context, new RequestMatcherFactory());
            }
            catch (NoSuchBeanDefinitionException ex) {
                return EMPTY_MATCHER;
            }
        }

        protected abstract RequestMatcher createDelegate(WebApplicationContext var1, RequestMatcherFactory var2);

        protected final List<RequestMatcher> getDelegateMatchers(RequestMatcherFactory requestMatcherFactory, RequestMatcherProvider matcherProvider, Set<String> paths, @Nullable HttpMethod httpMethod) {
            return paths.stream().map(path -> requestMatcherFactory.antPath(matcherProvider, httpMethod, (String)path, "/**")).collect(Collectors.toCollection(ArrayList::new));
        }

        protected List<RequestMatcher> getLinksMatchers(RequestMatcherFactory requestMatcherFactory, RequestMatcherProvider matcherProvider, String basePath) {
            ArrayList<RequestMatcher> linksMatchers = new ArrayList<RequestMatcher>();
            linksMatchers.add(requestMatcherFactory.antPath(matcherProvider, null, basePath));
            linksMatchers.add(requestMatcherFactory.antPath(matcherProvider, null, basePath, "/"));
            return linksMatchers;
        }

        protected RequestMatcherProvider getRequestMatcherProvider(WebApplicationContext context) {
            try {
                return (RequestMatcherProvider)context.getBean(RequestMatcherProvider.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                return (pattern, method) -> PathPatternRequestMatcher.withDefaults().matcher(method, pattern);
            }
        }

        protected String toString(List<Object> endpoints, String emptyValue) {
            return !endpoints.isEmpty() ? endpoints.stream().map(this::getEndpointId).map(Object::toString).collect(Collectors.joining(", ", "[", "]")) : emptyValue;
        }

        protected EndpointId getEndpointId(Object source) {
            if (source instanceof EndpointId) {
                EndpointId endpointId = (EndpointId)source;
                return endpointId;
            }
            if (source instanceof String) {
                String string = (String)source;
                return EndpointId.of((String)string);
            }
            if (source instanceof Class) {
                Class sourceClass = (Class)source;
                return this.getEndpointId(sourceClass);
            }
            throw new IllegalStateException("Unsupported source " + String.valueOf(source));
        }

        private EndpointId getEndpointId(Class<?> source) {
            MergedAnnotation annotation = MergedAnnotations.from(source).get(Endpoint.class);
            Assert.state((boolean)annotation.isPresent(), () -> "Class " + String.valueOf(source) + " is not annotated with @Endpoint");
            return EndpointId.of((String)annotation.getString("id"));
        }
    }
}

