/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.json;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.jackson.JsonComponent;
import org.springframework.boot.test.autoconfigure.filter.AnnotationCustomizableTypeExcludeFilter;
import org.springframework.boot.test.autoconfigure.json.JsonTest;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;

class JsonExcludeFilter
extends AnnotationCustomizableTypeExcludeFilter {
    private static final String JACKSON_MODULE = "com.fasterxml.jackson.databind.Module";
    private static final Set<Class<?>> DEFAULT_INCLUDES;
    private final JsonTest annotation;

    JsonExcludeFilter(Class<?> testClass) {
        this.annotation = (JsonTest)AnnotatedElementUtils.getMergedAnnotation(testClass, JsonTest.class);
    }

    @Override
    protected boolean hasAnnotation() {
        return this.annotation != null;
    }

    @Override
    protected ComponentScan.Filter[] getFilters(AnnotationCustomizableTypeExcludeFilter.FilterType type) {
        switch (type) {
            case INCLUDE: {
                return this.annotation.includeFilters();
            }
            case EXCLUDE: {
                return this.annotation.excludeFilters();
            }
        }
        throw new IllegalStateException("Unsupported type " + (Object)((Object)type));
    }

    @Override
    protected boolean isUseDefaultFilters() {
        return this.annotation.useDefaultFilters();
    }

    @Override
    protected Set<Class<?>> getDefaultIncludes() {
        return DEFAULT_INCLUDES;
    }

    @Override
    protected Set<Class<?>> getComponentIncludes() {
        return Collections.emptySet();
    }

    static {
        LinkedHashSet<Class<JsonComponent>> includes = new LinkedHashSet<Class<JsonComponent>>();
        try {
            includes.add(ClassUtils.forName((String)JACKSON_MODULE, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        includes.add(JsonComponent.class);
        DEFAULT_INCLUDES = Collections.unmodifiableSet(includes);
    }
}

