/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.actuate.metrics;

import java.util.List;
import org.springframework.boot.test.autoconfigure.actuate.metrics.AutoConfigureMetrics;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;

class MetricsExportContextCustomizerFactory
implements ContextCustomizerFactory {
    MetricsExportContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        boolean disableMetricsExport = TestContextAnnotationUtils.findMergedAnnotation(testClass, AutoConfigureMetrics.class) == null;
        return disableMetricsExport ? new DisableMetricExportContextCustomizer() : null;
    }

    static class DisableMetricExportContextCustomizer
    implements ContextCustomizer {
        DisableMetricExportContextCustomizer() {
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
            TestPropertyValues.of((String[])new String[]{"management.defaults.metrics.export.enabled=false", "management.simple.metrics.export.enabled=true"}).applyTo(context);
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

