/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.restdocs;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.test.autoconfigure.restdocs.RestDocsProperties;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcBuilderCustomizer;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentationConfigurer;
import org.springframework.restdocs.mockmvc.RestDocumentationResultHandler;
import org.springframework.restdocs.mockmvc.UriConfigurer;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;

public class RestDocsMockMvcBuilderCustomizer
implements InitializingBean,
MockMvcBuilderCustomizer {
    private final RestDocsProperties properties;
    private final MockMvcRestDocumentationConfigurer delegate;
    private final @Nullable RestDocumentationResultHandler resultHandler;

    RestDocsMockMvcBuilderCustomizer(RestDocsProperties properties, MockMvcRestDocumentationConfigurer delegate, @Nullable RestDocumentationResultHandler resultHandler) {
        this.properties = properties;
        this.delegate = delegate;
        this.resultHandler = resultHandler;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyMapper map = PropertyMapper.get();
        RestDocsProperties properties = this.properties;
        UriConfigurer uri = this.delegate.uris();
        map.from(properties::getUriScheme).whenHasText().to(arg_0 -> ((UriConfigurer)uri).withScheme(arg_0));
        map.from(properties::getUriHost).whenHasText().to(arg_0 -> ((UriConfigurer)uri).withHost(arg_0));
        map.from(properties::getUriPort).to(arg_0 -> ((UriConfigurer)uri).withPort(arg_0));
    }

    @Override
    public void customize(ConfigurableMockMvcBuilder<?> builder) {
        builder.apply((MockMvcConfigurer)this.delegate);
        if (this.resultHandler != null) {
            builder.alwaysDo((ResultHandler)this.resultHandler);
        }
    }
}

