/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.restdocs;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.test.autoconfigure.restdocs.RestDocsProperties;
import org.springframework.boot.web.server.test.client.reactive.WebTestClientBuilderCustomizer;
import org.springframework.restdocs.webtestclient.WebTestClientRestDocumentationConfigurer;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;

class RestDocsWebTestClientBuilderCustomizer
implements WebTestClientBuilderCustomizer {
    private final RestDocsProperties properties;
    private final WebTestClientRestDocumentationConfigurer delegate;

    RestDocsWebTestClientBuilderCustomizer(RestDocsProperties properties, WebTestClientRestDocumentationConfigurer delegate) {
        this.properties = properties;
        this.delegate = delegate;
    }

    public void customize(WebTestClient.Builder builder) {
        this.customizeBaseUrl(builder);
        builder.filter((ExchangeFilterFunction)this.delegate);
    }

    private void customizeBaseUrl(WebTestClient.Builder builder) {
        String scheme = this.properties.getUriScheme();
        String host = this.properties.getUriHost();
        String baseUrl = (StringUtils.hasText((String)scheme) ? scheme : "http") + "://" + (StringUtils.hasText((String)host) ? host : "localhost");
        Integer port = this.properties.getUriPort();
        if (!this.isStandardPort(scheme, port)) {
            baseUrl = baseUrl + ":" + port;
        }
        builder.baseUrl(baseUrl);
    }

    private boolean isStandardPort(@Nullable String scheme, @Nullable Integer port) {
        if (port == null) {
            return true;
        }
        return "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443;
    }
}

