/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.context.annotation.UserConfigurations;
import org.springframework.boot.test.context.assertj.ApplicationContextAssertProvider;
import org.springframework.boot.test.context.runner.ContextConsumer;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.Assert;

abstract class AbstractApplicationContextRunner<SELF extends AbstractApplicationContextRunner<SELF, C, A>, C extends ConfigurableApplicationContext, A extends ApplicationContextAssertProvider<C>> {
    private final Supplier<C> contextFactory;
    private final TestPropertyValues environmentProperties;
    private final TestPropertyValues systemProperties;
    private final ClassLoader classLoader;
    private final ApplicationContext parent;
    private final List<Configurations> configurations;

    protected AbstractApplicationContextRunner(Supplier<C> contextFactory) {
        this(contextFactory, TestPropertyValues.empty(), TestPropertyValues.empty(), null, null, Collections.emptyList());
    }

    protected AbstractApplicationContextRunner(Supplier<C> contextFactory, TestPropertyValues environmentProperties, TestPropertyValues systemProperties, ClassLoader classLoader, ApplicationContext parent, List<Configurations> configurations) {
        Assert.notNull(contextFactory, (String)"ContextFactory must not be null");
        Assert.notNull((Object)environmentProperties, (String)"EnvironmentProperties must not be null");
        Assert.notNull((Object)systemProperties, (String)"SystemProperties must not be null");
        Assert.notNull(configurations, (String)"Configurations must not be null");
        this.contextFactory = contextFactory;
        this.environmentProperties = environmentProperties;
        this.systemProperties = systemProperties;
        this.classLoader = classLoader;
        this.parent = parent;
        this.configurations = Collections.unmodifiableList(configurations);
    }

    public SELF withPropertyValues(String ... pairs) {
        return this.newInstance(this.contextFactory, this.environmentProperties.and(pairs), this.systemProperties, this.classLoader, this.parent, this.configurations);
    }

    public SELF withSystemProperties(String ... pairs) {
        return this.newInstance(this.contextFactory, this.environmentProperties, this.systemProperties.and(pairs), this.classLoader, this.parent, this.configurations);
    }

    public SELF withClassLoader(ClassLoader classLoader) {
        return this.newInstance(this.contextFactory, this.environmentProperties, this.systemProperties, classLoader, this.parent, this.configurations);
    }

    public SELF withParent(ApplicationContext parent) {
        return this.newInstance(this.contextFactory, this.environmentProperties, this.systemProperties, this.classLoader, parent, this.configurations);
    }

    public SELF withUserConfiguration(Class<?> ... configurationClasses) {
        return this.withConfiguration((Configurations)UserConfigurations.of((Class[])configurationClasses));
    }

    public SELF withConfiguration(Configurations configurations) {
        Assert.notNull((Object)configurations, (String)"Configurations must not be null");
        return this.newInstance(this.contextFactory, this.environmentProperties, this.systemProperties, this.classLoader, this.parent, this.add(this.configurations, configurations));
    }

    public SELF with(Function<SELF, SELF> customizer) {
        return (SELF)((AbstractApplicationContextRunner)customizer.apply(this));
    }

    private <T> List<T> add(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(element);
        return result;
    }

    protected abstract SELF newInstance(Supplier<C> var1, TestPropertyValues var2, TestPropertyValues var3, ClassLoader var4, ApplicationContext var5, List<Configurations> var6);

    public SELF run(ContextConsumer<? super A> consumer) {
        this.systemProperties.applyToSystemProperties(() -> {
            try (A context = this.createAssertableContext();){
                this.accept(consumer, context);
            }
            return null;
        });
        return (SELF)this;
    }

    private A createAssertableContext() {
        ResolvableType resolvableType = ResolvableType.forClass(AbstractApplicationContextRunner.class, this.getClass());
        Class assertType = resolvableType.resolveGeneric(new int[]{1});
        Class contextType = resolvableType.resolveGeneric(new int[]{2});
        return (A)ApplicationContextAssertProvider.get(assertType, contextType, this::createAndLoadContext);
    }

    private C createAndLoadContext() {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)this.contextFactory.get();
        try {
            this.configureContext(context);
            return (C)context;
        }
        catch (RuntimeException ex) {
            context.close();
            throw ex;
        }
    }

    private void configureContext(C context) {
        if (this.parent != null) {
            context.setParent(this.parent);
        }
        if (this.classLoader != null) {
            Assert.isInstanceOf(DefaultResourceLoader.class, context);
            ((DefaultResourceLoader)context).setClassLoader(this.classLoader);
        }
        this.environmentProperties.applyTo((ConfigurableApplicationContext)context);
        Class[] classes = Configurations.getClasses(this.configurations);
        if (classes.length > 0) {
            ((AnnotationConfigRegistry)context).register(classes);
        }
        context.refresh();
    }

    private void accept(ContextConsumer<? super A> consumer, A context) {
        try {
            consumer.accept(context);
        }
        catch (Throwable ex) {
            this.rethrow(ex);
        }
    }

    private <E extends Throwable> void rethrow(Throwable e) throws E {
        throw e;
    }
}

