/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.boot.test.json.JsonContent;
import org.springframework.boot.test.json.JsonLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class BasicJsonTester {
    private JsonLoader loader;

    protected BasicJsonTester() {
    }

    public BasicJsonTester(Class<?> resourceLoadClass) {
        this(resourceLoadClass, null);
    }

    public BasicJsonTester(Class<?> resourceLoadClass, Charset charset) {
        Assert.notNull(resourceLoadClass, (String)"ResourceLoadClass must not be null");
        this.loader = new JsonLoader(resourceLoadClass, charset);
    }

    protected final void initialize(Class<?> resourceLoadClass) {
        this.initialize(resourceLoadClass, null);
    }

    protected final void initialize(Class<?> resourceLoadClass, Charset charset) {
        if (this.loader == null) {
            this.loader = new JsonLoader(resourceLoadClass, charset);
        }
    }

    public JsonContent<Object> from(CharSequence source) {
        this.verify();
        return this.getJsonContent(this.loader.getJson(source));
    }

    public JsonContent<Object> from(String path, Class<?> resourceLoadClass) {
        this.verify();
        return this.getJsonContent(this.loader.getJson(path, resourceLoadClass));
    }

    public JsonContent<Object> from(byte[] source) {
        this.verify();
        return this.getJsonContent(this.loader.getJson(source));
    }

    public JsonContent<Object> from(File source) {
        this.verify();
        return this.getJsonContent(this.loader.getJson(source));
    }

    public JsonContent<Object> from(InputStream source) {
        this.verify();
        return this.getJsonContent(this.loader.getJson(source));
    }

    public JsonContent<Object> from(Resource source) {
        this.verify();
        return this.getJsonContent(this.loader.getJson(source));
    }

    private void verify() {
        Assert.state((this.loader != null ? 1 : 0) != 0, (String)"Uninitialized BasicJsonTester");
    }

    private JsonContent<Object> getJsonContent(String json) {
        return new JsonContent<Object>(this.loader.getResourceLoadClass(), null, json);
    }
}

