/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.test.json.JsonContent;
import org.springframework.boot.test.json.ObjectContent;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractJsonMarshalTester<T> {
    private @Nullable Class<?> resourceLoadClass;
    private @Nullable ResolvableType type;

    protected AbstractJsonMarshalTester() {
    }

    public AbstractJsonMarshalTester(Class<?> resourceLoadClass, ResolvableType type) {
        Assert.notNull(resourceLoadClass, (String)"'resourceLoadClass' must not be null");
        Assert.notNull((Object)type, (String)"'type' must not be null");
        this.initialize(resourceLoadClass, type);
    }

    protected final void initialize(Class<?> resourceLoadClass, ResolvableType type) {
        if (this.resourceLoadClass == null && this.type == null) {
            this.resourceLoadClass = resourceLoadClass;
            this.type = type;
        }
    }

    protected final @Nullable ResolvableType getType() {
        return this.type;
    }

    private ResolvableType getTypeNotNull() {
        ResolvableType type = this.getType();
        Assert.state((type != null ? 1 : 0) != 0, (String)"Instance has not been initialized");
        return type;
    }

    protected final @Nullable Class<?> getResourceLoadClass() {
        return this.resourceLoadClass;
    }

    private Class<?> getResourceLoadClassNotNull() {
        Class<?> resourceLoadClass = this.getResourceLoadClass();
        Assert.state((resourceLoadClass != null ? 1 : 0) != 0, (String)"Instance has not been initialized");
        return resourceLoadClass;
    }

    public JsonContent<T> write(T value) throws IOException {
        this.verify();
        Assert.notNull(value, (String)"'value' must not be null");
        String json = this.writeObject(value, this.getTypeNotNull());
        return this.getJsonContent(json);
    }

    protected JsonContent<T> getJsonContent(String json) {
        return new JsonContent(this.getResourceLoadClassNotNull(), this.getType(), json);
    }

    public T parseObject(byte[] jsonBytes) throws IOException {
        this.verify();
        return this.parse(jsonBytes).getObject();
    }

    public ObjectContent<T> parse(byte[] jsonBytes) throws IOException {
        this.verify();
        Assert.notNull((Object)jsonBytes, (String)"'jsonBytes' must not be null");
        return this.read((Resource)new ByteArrayResource(jsonBytes));
    }

    public T parseObject(String jsonString) throws IOException {
        this.verify();
        return this.parse(jsonString).getObject();
    }

    public ObjectContent<T> parse(String jsonString) throws IOException {
        this.verify();
        Assert.notNull((Object)jsonString, (String)"'jsonString' must not be null");
        return this.read(new StringReader(jsonString));
    }

    public T readObject(String resourcePath) throws IOException {
        this.verify();
        return this.read(resourcePath).getObject();
    }

    public ObjectContent<T> read(String resourcePath) throws IOException {
        this.verify();
        Assert.notNull((Object)resourcePath, (String)"'resourcePath' must not be null");
        return this.read((Resource)new ClassPathResource(resourcePath, this.resourceLoadClass));
    }

    public T readObject(File file) throws IOException {
        this.verify();
        return this.read(file).getObject();
    }

    public ObjectContent<T> read(File file) throws IOException {
        this.verify();
        Assert.notNull((Object)file, (String)"'file' must not be null");
        return this.read((Resource)new FileSystemResource(file));
    }

    public T readObject(InputStream inputStream) throws IOException {
        this.verify();
        return this.read(inputStream).getObject();
    }

    public ObjectContent<T> read(InputStream inputStream) throws IOException {
        this.verify();
        Assert.notNull((Object)inputStream, (String)"'inputStream' must not be null");
        return this.read((Resource)new InputStreamResource(inputStream));
    }

    public T readObject(Resource resource) throws IOException {
        this.verify();
        return this.read(resource).getObject();
    }

    public ObjectContent<T> read(Resource resource) throws IOException {
        this.verify();
        Assert.notNull((Object)resource, (String)"'resource' must not be null");
        InputStream inputStream = resource.getInputStream();
        T object = this.readObject(inputStream, this.getTypeNotNull());
        this.closeQuietly(inputStream);
        return new ObjectContent<T>(this.type, object);
    }

    public T readObject(Reader reader) throws IOException {
        this.verify();
        return this.read(reader).getObject();
    }

    public ObjectContent<T> read(Reader reader) throws IOException {
        this.verify();
        Assert.notNull((Object)reader, (String)"'reader' must not be null");
        T object = this.readObject(reader, this.getTypeNotNull());
        this.closeQuietly(reader);
        return new ObjectContent<T>(this.type, object);
    }

    private void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void verify() {
        Assert.state((this.resourceLoadClass != null ? 1 : 0) != 0, (String)"Uninitialized JsonMarshalTester (ResourceLoadClass is null)");
        Assert.state((this.type != null ? 1 : 0) != 0, (String)"Uninitialized JsonMarshalTester (Type is null)");
    }

    protected abstract String writeObject(T var1, ResolvableType var2) throws IOException;

    protected T readObject(InputStream inputStream, ResolvableType type) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        return this.readObject(reader, type);
    }

    protected abstract T readObject(Reader var1, ResolvableType var2) throws IOException;

    protected static abstract class FieldInitializer<M> {
        private final Class<?> testerClass;

        protected FieldInitializer(Class<? extends AbstractJsonMarshalTester> testerClass) {
            Assert.notNull(testerClass, (String)"'testerClass' must not be null");
            this.testerClass = testerClass;
        }

        public void initFields(Object testInstance, M marshaller) {
            Assert.notNull((Object)testInstance, (String)"'testInstance' must not be null");
            Assert.notNull(marshaller, (String)"'marshaller' must not be null");
            this.initFields(testInstance, () -> marshaller);
        }

        public void initFields(Object testInstance, ObjectFactory<M> marshaller) {
            Assert.notNull((Object)testInstance, (String)"'testInstance' must not be null");
            Assert.notNull(marshaller, (String)"'marshaller' must not be null");
            ReflectionUtils.doWithFields(testInstance.getClass(), field -> this.doWithField(field, testInstance, marshaller));
        }

        protected void doWithField(Field field, Object test, ObjectFactory<M> marshaller) {
            if (this.testerClass.isAssignableFrom(field.getType())) {
                ReflectionUtils.makeAccessible((Field)field);
                Object existingValue = ReflectionUtils.getField((Field)field, (Object)test);
                if (existingValue == null) {
                    this.setupField(field, test, marshaller);
                }
            }
        }

        private void setupField(Field field, Object test, ObjectFactory<M> marshaller) {
            ResolvableType type = ResolvableType.forField((Field)field).getGeneric(new int[0]);
            ReflectionUtils.setField((Field)field, (Object)test, this.createTester(test.getClass(), type, marshaller.getObject()));
        }

        protected abstract AbstractJsonMarshalTester<Object> createTester(Class<?> var1, ResolvableType var2, M var3);
    }
}

