/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.aot.BeanRegistrationExcludeFilter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactories;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactoryNotFoundException;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsNotFoundException;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.springframework.boot.testcontainers.service.connection.ServiceConnection;
import org.springframework.core.log.LogMessage;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class ConnectionDetailsRegistrar {
    private static final Log logger = LogFactory.getLog(ConnectionDetailsRegistrar.class);
    private final ListableBeanFactory beanFactory;
    private final ConnectionDetailsFactories connectionDetailsFactories;

    ConnectionDetailsRegistrar(ListableBeanFactory beanFactory, ConnectionDetailsFactories connectionDetailsFactories) {
        this.beanFactory = beanFactory;
        this.connectionDetailsFactories = connectionDetailsFactories;
    }

    void registerBeanDefinitions(BeanDefinitionRegistry registry, Collection<ContainerConnectionSource<?>> sources) {
        sources.forEach(source -> this.registerBeanDefinitions(registry, (ContainerConnectionSource<?>)source));
    }

    void registerBeanDefinitions(BeanDefinitionRegistry registry, ContainerConnectionSource<?> source) {
        try {
            this.connectionDetailsFactories.getConnectionDetails(source, true).forEach((connectionDetailsType, connectionDetails) -> this.registerBeanDefinition(registry, source, (Class<?>)connectionDetailsType, (ConnectionDetails)connectionDetails));
        }
        catch (ConnectionDetailsFactoryNotFoundException ex) {
            this.rethrowConnectionDetails(source, (RuntimeException)((Object)ex), ConnectionDetailsFactoryNotFoundException::new);
        }
        catch (ConnectionDetailsNotFoundException ex) {
            this.rethrowConnectionDetails(source, (RuntimeException)((Object)ex), ConnectionDetailsNotFoundException::new);
        }
    }

    private void rethrowConnectionDetails(ContainerConnectionSource<?> source, RuntimeException ex, BiFunction<String, Throwable, RuntimeException> exceptionFactory) {
        if (!StringUtils.hasText((String)source.getConnectionName())) {
            StringBuilder message;
            message.append(!(message = new StringBuilder(ex.getMessage())).toString().endsWith(".") ? "." : "");
            message.append(" You may need to add a 'name' to your @ServiceConnection annotation");
            throw exceptionFactory.apply(message.toString(), ex.getCause());
        }
        throw ex;
    }

    private <T> void registerBeanDefinition(BeanDefinitionRegistry registry, ContainerConnectionSource<?> source, Class<?> connectionDetailsType, ConnectionDetails connectionDetails) {
        Object[] existingBeans = this.beanFactory.getBeanNamesForType(connectionDetailsType);
        if (!ObjectUtils.isEmpty((Object[])existingBeans)) {
            logger.debug((Object)LogMessage.of(() -> ConnectionDetailsRegistrar.lambda$registerBeanDefinition$2(source, (String[])existingBeans)));
            return;
        }
        String beanName = this.getBeanName(source, connectionDetails);
        Class<?> beanType = connectionDetails.getClass();
        Supplier<Object> beanSupplier = () -> connectionDetails;
        logger.debug((Object)LogMessage.of(() -> "Registering '%s' for %s".formatted(beanName, source)));
        RootBeanDefinition beanDefinition = new RootBeanDefinition(beanType, beanSupplier);
        beanDefinition.setAttribute(ServiceConnection.class.getName(), (Object)true);
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    private String getBeanName(ContainerConnectionSource<?> source, ConnectionDetails connectionDetails) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(ClassUtils.getShortNameAsProperty(connectionDetails.getClass()));
        parts.add("for");
        parts.add(source.getBeanNameSuffix());
        return StringUtils.uncapitalize((String)parts.stream().map(StringUtils::capitalize).collect(Collectors.joining()));
    }

    private static /* synthetic */ CharSequence lambda$registerBeanDefinition$2(ContainerConnectionSource source, String[] existingBeans) {
        return "Skipping registration of %s due to existing beans %s".formatted(source, Arrays.asList(existingBeans));
    }

    class ServiceConnectionBeanRegistrationExcludeFilter
    implements BeanRegistrationExcludeFilter {
        ServiceConnectionBeanRegistrationExcludeFilter() {
        }

        public boolean isExcludedFromAotProcessing(RegisteredBean registeredBean) {
            return registeredBean.getMergedBeanDefinition().getAttribute(ServiceConnection.class.getName()) != null;
        }
    }
}

