/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.properties;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.testcontainers.properties.BeforeTestcontainersPropertySuppliedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.util.Assert;
import org.springframework.util.function.SupplierUtils;

public class TestcontainersPropertySource
extends MapPropertySource {
    static final String NAME = "testcontainersPropertySource";
    private final DynamicPropertyRegistry registry;
    private final Set<ApplicationEventPublisher> eventPublishers = new CopyOnWriteArraySet<ApplicationEventPublisher>();

    TestcontainersPropertySource() {
        this(Collections.synchronizedMap(new LinkedHashMap()));
    }

    private TestcontainersPropertySource(Map<String, Supplier<Object>> valueSuppliers) {
        super(NAME, Collections.unmodifiableMap(valueSuppliers));
        this.registry = (name, valueSupplier) -> {
            Assert.hasText((String)name, (String)"'name' must not be null or blank");
            Assert.notNull((Object)valueSupplier, (String)"'valueSupplier' must not be null");
            valueSuppliers.put(name, valueSupplier);
        };
    }

    private void addEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublishers.add(eventPublisher);
    }

    public Object getProperty(String name) {
        Object valueSupplier = ((Map)this.source).get(name);
        return valueSupplier != null ? this.getProperty(name, valueSupplier) : null;
    }

    private Object getProperty(String name, Object valueSupplier) {
        BeforeTestcontainersPropertySuppliedEvent event = new BeforeTestcontainersPropertySuppliedEvent(this, name);
        this.eventPublishers.forEach(eventPublisher -> eventPublisher.publishEvent((ApplicationEvent)event));
        return SupplierUtils.resolve((Object)valueSupplier);
    }

    public static DynamicPropertyRegistry attach(Environment environment) {
        return TestcontainersPropertySource.attach(environment, null);
    }

    static DynamicPropertyRegistry attach(ConfigurableApplicationContext applicationContext) {
        return TestcontainersPropertySource.attach((Environment)applicationContext.getEnvironment(), (ApplicationEventPublisher)applicationContext, null);
    }

    public static DynamicPropertyRegistry attach(Environment environment, BeanDefinitionRegistry registry) {
        return TestcontainersPropertySource.attach(environment, null, registry);
    }

    private static DynamicPropertyRegistry attach(Environment environment, ApplicationEventPublisher eventPublisher, BeanDefinitionRegistry registry) {
        Assert.state((boolean)(environment instanceof ConfigurableEnvironment), (String)"TestcontainersPropertySource can only be attached to a ConfigurableEnvironment");
        TestcontainersPropertySource propertySource = TestcontainersPropertySource.getOrAdd((ConfigurableEnvironment)environment);
        if (eventPublisher != null) {
            propertySource.addEventPublisher(eventPublisher);
        } else if (registry != null && !registry.containsBeanDefinition(EventPublisherRegistrar.NAME)) {
            registry.registerBeanDefinition(EventPublisherRegistrar.NAME, (BeanDefinition)new RootBeanDefinition(EventPublisherRegistrar.class, () -> new EventPublisherRegistrar(environment)));
        }
        return propertySource.registry;
    }

    static TestcontainersPropertySource getOrAdd(ConfigurableEnvironment environment) {
        PropertySource propertySource = environment.getPropertySources().get(NAME);
        if (propertySource == null) {
            environment.getPropertySources().addFirst((PropertySource)new TestcontainersPropertySource());
            return TestcontainersPropertySource.getOrAdd(environment);
        }
        Assert.state((boolean)(propertySource instanceof TestcontainersPropertySource), (String)"Incorrect TestcontainersPropertySource type registered");
        return (TestcontainersPropertySource)propertySource;
    }

    static class EventPublisherRegistrar
    implements BeanFactoryPostProcessor,
    ApplicationEventPublisherAware {
        static final String NAME = EventPublisherRegistrar.class.getName();
        private final Environment environment;
        private ApplicationEventPublisher eventPublisher;

        EventPublisherRegistrar(Environment environment) {
            this.environment = environment;
        }

        public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
            this.eventPublisher = eventPublisher;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            if (this.eventPublisher != null) {
                TestcontainersPropertySource.getOrAdd((ConfigurableEnvironment)this.environment).addEventPublisher(this.eventPublisher);
            }
        }
    }
}

