/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.yaml;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.boot.yaml.YamlProcessor;

public class YamlMapFactoryBean
extends YamlProcessor
implements FactoryBean<Map<String, Object>> {
    private boolean singleton = true;
    private Map<String, Object> instance;

    public Map<String, Object> getObject() {
        if (!this.singleton || this.instance == null) {
            final LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            this.process(new YamlProcessor.MatchCallback(){

                @Override
                public void process(Properties properties, Map<String, Object> map) {
                    YamlMapFactoryBean.this.merge(result, map);
                }
            });
            this.instance = result;
        }
        return this.instance;
    }

    private void merge(Map<String, Object> output, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Object existing = output.get(key);
            if (value instanceof Map && existing instanceof Map) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>((Map)existing);
                this.merge(result, (Map)value);
                output.put(key, result);
                continue;
            }
            output.put(key, value);
        }
    }

    public Class<?> getObjectType() {
        return Map.class;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSingleton() {
        return this.singleton;
    }
}

