/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.beans.PropertyEditor;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.boot.bind.InetAddressEditor;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

public class RelaxedDataBinder
extends DataBinder {
    private String namePrefix;
    private boolean ignoreNestedProperties;

    public RelaxedDataBinder(Object target) {
        super(RelaxedDataBinder.wrapTarget(target));
    }

    public RelaxedDataBinder(Object target, String namePrefix) {
        super(RelaxedDataBinder.wrapTarget(target), StringUtils.hasLength((String)namePrefix) ? namePrefix : "target");
        this.namePrefix = StringUtils.hasLength((String)namePrefix) ? namePrefix + "." : null;
    }

    public void setIgnoreNestedProperties(boolean ignoreNestedProperties) {
        this.ignoreNestedProperties = ignoreNestedProperties;
    }

    protected void doBind(MutablePropertyValues propertyValues) {
        propertyValues = this.modifyProperties(propertyValues, this.getTarget());
        this.getPropertyEditorRegistry().registerCustomEditor(InetAddress.class, (PropertyEditor)new InetAddressEditor());
        super.doBind(propertyValues);
    }

    private MutablePropertyValues modifyProperties(MutablePropertyValues propertyValues, Object target) {
        propertyValues = this.getPropertyValuesForNamePrefix(propertyValues);
        if (target instanceof MapHolder) {
            propertyValues = this.addMapPrefix(propertyValues);
        }
        BeanWrapperImpl targetWrapper = new BeanWrapperImpl(target);
        targetWrapper.setAutoGrowNestedPaths(true);
        List list = propertyValues.getPropertyValueList();
        for (int i = 0; i < list.size(); ++i) {
            this.modifyProperty(propertyValues, (BeanWrapper)targetWrapper, (PropertyValue)list.get(i), i);
        }
        return propertyValues;
    }

    private MutablePropertyValues addMapPrefix(MutablePropertyValues propertyValues) {
        MutablePropertyValues rtn = new MutablePropertyValues();
        for (PropertyValue pv : propertyValues.getPropertyValues()) {
            rtn.add("map." + pv.getName(), pv.getValue());
        }
        return rtn;
    }

    private MutablePropertyValues getPropertyValuesForNamePrefix(MutablePropertyValues propertyValues) {
        if (!StringUtils.hasText((String)this.namePrefix) && !this.ignoreNestedProperties) {
            return propertyValues;
        }
        MutablePropertyValues rtn = new MutablePropertyValues();
        for (PropertyValue value : propertyValues.getPropertyValues()) {
            String name = value.getName();
            for (String candidate : new RelaxedNames(this.namePrefix)) {
                if (!name.startsWith(candidate)) continue;
                name = name.substring(candidate.length());
                if (this.ignoreNestedProperties && name.contains(".")) continue;
                rtn.add(name, value.getValue());
            }
        }
        return rtn;
    }

    private void modifyProperty(MutablePropertyValues propertyValues, BeanWrapper target, PropertyValue propertyValue, int index) {
        String oldName = propertyValue.getName();
        String name = this.normalizePath(target, oldName);
        if (!name.equals(oldName)) {
            propertyValues.setPropertyValueAt(new PropertyValue(name, propertyValue.getValue()), index);
        }
    }

    protected String normalizePath(BeanWrapper wrapper, String path) {
        return this.initializePath(wrapper, new BeanPath(path), 0);
    }

    private String initializePath(BeanWrapper wrapper, BeanPath path, int index) {
        String prefix = path.prefix(index);
        String key = path.name(index);
        if (path.isProperty(index)) {
            key = this.getActualPropertyName(wrapper, prefix, key);
            path.rename(index, key);
        }
        if (path.name(++index) == null) {
            return path.toString();
        }
        String name = path.prefix(index);
        TypeDescriptor descriptor = wrapper.getPropertyTypeDescriptor(name);
        if (descriptor == null || descriptor.isMap()) {
            if (descriptor != null) {
                Class valueType;
                wrapper.getPropertyValue(name + "[foo]");
                TypeDescriptor valueDescriptor = descriptor.getMapValueTypeDescriptor();
                if (valueDescriptor != null && (valueType = valueDescriptor.getObjectType()) != null && CharSequence.class.isAssignableFrom(valueType)) {
                    path.collapseKeys(index);
                }
            }
            path.mapIndex(index);
            this.extendMapIfNecessary(wrapper, path, index);
        } else if (descriptor.isCollection()) {
            this.extendCollectionIfNecessary(wrapper, path, index);
        } else if (descriptor.getType().equals(Object.class)) {
            path.mapIndex(index);
            String next = path.prefix(index + 1);
            if (wrapper.getPropertyValue(next) == null) {
                wrapper.setPropertyValue(next, new LinkedHashMap());
            }
        }
        return this.initializePath(wrapper, path, index);
    }

    private void extendCollectionIfNecessary(BeanWrapper wrapper, BeanPath path, int index) {
        String name = path.prefix(index);
        TypeDescriptor elementDescriptor = wrapper.getPropertyTypeDescriptor(name).getElementTypeDescriptor();
        if (!(elementDescriptor.isMap() || elementDescriptor.isCollection() || elementDescriptor.getType().equals(Object.class))) {
            return;
        }
        Cloneable extend = new LinkedHashMap();
        if (!elementDescriptor.isMap() && path.isArrayIndex(index + 1)) {
            extend = new ArrayList();
        }
        wrapper.setPropertyValue(path.prefix(index + 1), extend);
    }

    private void extendMapIfNecessary(BeanWrapper wrapper, BeanPath path, int index) {
        String name = path.prefix(index);
        TypeDescriptor parent = wrapper.getPropertyTypeDescriptor(name);
        if (parent == null) {
            return;
        }
        TypeDescriptor descriptor = parent.getMapValueTypeDescriptor();
        if (descriptor == null) {
            descriptor = TypeDescriptor.valueOf(Object.class);
        }
        if (!(descriptor.isMap() || descriptor.isCollection() || descriptor.getType().equals(Object.class))) {
            return;
        }
        String extensionName = path.prefix(index + 1);
        if (wrapper.isReadableProperty(extensionName)) {
            Object currentValue = wrapper.getPropertyValue(extensionName);
            if (descriptor.isCollection() && currentValue instanceof Collection || !descriptor.isCollection() && currentValue instanceof Map) {
                return;
            }
        }
        Cloneable extend = new LinkedHashMap();
        if (descriptor.isCollection()) {
            extend = new ArrayList();
        }
        wrapper.setPropertyValue(extensionName, extend);
    }

    private String getActualPropertyName(BeanWrapper target, String prefix, String name) {
        prefix = StringUtils.hasText((String)prefix) ? prefix + "." : "";
        for (String candidate : new RelaxedNames(name)) {
            try {
                if (target.getPropertyType(prefix + candidate) == null) continue;
                return candidate;
            }
            catch (InvalidPropertyException ex) {
            }
        }
        return name;
    }

    private static Object wrapTarget(Object target) {
        if (target instanceof Map) {
            Map map = (Map)target;
            target = new MapHolder(map);
        }
        return target;
    }

    private static class BeanPath {
        private List<PathNode> nodes;

        public BeanPath(String path) {
            this.nodes = this.splitPath(path);
        }

        private List<PathNode> splitPath(String path) {
            ArrayList<PathNode> nodes = new ArrayList<PathNode>();
            for (String name : StringUtils.delimitedListToStringArray((String)path, (String)".")) {
                for (String sub : StringUtils.delimitedListToStringArray((String)name, (String)"[")) {
                    if (!StringUtils.hasText((String)sub)) continue;
                    if (sub.endsWith("]")) {
                        if ((sub = sub.substring(0, sub.length() - 1)).matches("[0-9]+")) {
                            nodes.add(new ArrayIndexNode(sub));
                            continue;
                        }
                        nodes.add(new MapIndexNode(sub));
                        continue;
                    }
                    nodes.add(new PropertyNode(sub));
                }
            }
            return nodes;
        }

        public void collapseKeys(int index) {
            ArrayList<PathNode> revised = new ArrayList<PathNode>();
            for (int i = 0; i < index; ++i) {
                revised.add(this.nodes.get(i));
            }
            StringBuilder builder = new StringBuilder();
            for (int i = index; i < this.nodes.size(); ++i) {
                if (i > index) {
                    builder.append(".");
                }
                builder.append(this.nodes.get((int)i).name);
            }
            revised.add(new PropertyNode(builder.toString()));
            this.nodes = revised;
        }

        public void mapIndex(int index) {
            PathNode node = this.nodes.get(index);
            if (node instanceof PropertyNode) {
                node = ((PropertyNode)node).mapIndex();
            }
            this.nodes.set(index, node);
        }

        public String prefix(int index) {
            return this.range(0, index);
        }

        public void rename(int index, String name) {
            this.nodes.get((int)index).name = name;
        }

        public String name(int index) {
            if (index < this.nodes.size()) {
                return this.nodes.get((int)index).name;
            }
            return null;
        }

        private String range(int start, int end) {
            StringBuilder builder = new StringBuilder();
            for (int i = start; i < end; ++i) {
                PathNode node = this.nodes.get(i);
                builder.append(node);
            }
            if (builder.toString().startsWith(".")) {
                builder.replace(0, 1, "");
            }
            return builder.toString();
        }

        public boolean isArrayIndex(int index) {
            return this.nodes.get(index) instanceof ArrayIndexNode;
        }

        public boolean isProperty(int index) {
            return this.nodes.get(index) instanceof PropertyNode;
        }

        public String toString() {
            return this.prefix(this.nodes.size());
        }

        private static class PropertyNode
        extends PathNode {
            public PropertyNode(String name) {
                super(name);
            }

            public MapIndexNode mapIndex() {
                return new MapIndexNode(this.name);
            }

            public String toString() {
                return "." + this.name;
            }
        }

        private static class MapIndexNode
        extends PathNode {
            public MapIndexNode(String name) {
                super(name);
            }

            public String toString() {
                return "[" + this.name + "]";
            }
        }

        private static class ArrayIndexNode
        extends PathNode {
            public ArrayIndexNode(String name) {
                super(name);
            }

            public String toString() {
                return "[" + this.name + "]";
            }
        }

        private static class PathNode {
            protected String name;

            public PathNode(String name) {
                this.name = name;
            }
        }
    }

    static class MapHolder {
        private Map<String, Object> map;

        public MapHolder(Map<String, Object> map) {
            this.map = map;
        }

        public void setMap(Map<String, Object> map) {
            this.map = map;
        }

        public Map<String, Object> getMap() {
            return this.map;
        }
    }
}

