/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.event;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.env.ConfigurableEnvironment;

public class EventPublishingRunListener
implements SpringApplicationRunListener {
    private final ApplicationEventMulticaster multicaster;
    private SpringApplication application;
    private String[] args;

    public EventPublishingRunListener(SpringApplication application, String[] args) {
        this.application = application;
        this.args = args;
        this.multicaster = new SimpleApplicationEventMulticaster();
        for (ApplicationListener<?> listener : application.getListeners()) {
            this.multicaster.addApplicationListener(listener);
        }
    }

    @Override
    public void started() {
        this.publishEvent(new ApplicationStartedEvent(this.application, this.args));
    }

    @Override
    public void environmentPrepared(ConfigurableEnvironment environment) {
        this.publishEvent(new ApplicationEnvironmentPreparedEvent(this.application, this.args, environment));
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {
        this.registerApplicationEventMulticaster(context);
    }

    private void registerApplicationEventMulticaster(ConfigurableApplicationContext context) {
        context.getBeanFactory().registerSingleton("applicationEventMulticaster", (Object)this.multicaster);
        if (this.multicaster instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.multicaster).setBeanFactory((BeanFactory)context.getBeanFactory());
        }
    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {
        this.publishEvent(new ApplicationPreparedEvent(this.application, this.args, context));
    }

    @Override
    public void finished(ConfigurableApplicationContext context, Throwable exception) {
        if (exception != null) {
            this.publishEvent(new ApplicationFailedEvent(this.application, this.args, context, exception));
        }
    }

    private void publishEvent(SpringApplicationEvent event) {
        this.multicaster.multicastEvent((ApplicationEvent)event);
    }
}

