/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.AbstractProtocol;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.boot.context.embedded.MimeMappings;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.tomcat.ServletContextInitializerLifecycleListener;
import org.springframework.boot.context.embedded.tomcat.SkipPatternJarScanner;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedContext;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedWebappClassLoader;
import org.springframework.boot.context.embedded.tomcat.TomcatResources;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StreamUtils;

public class TomcatEmbeddedServletContainerFactory
extends AbstractEmbeddedServletContainerFactory
implements ResourceLoaderAware {
    private static final String DEFAULT_PROTOCOL = "org.apache.coyote.http11.Http11NioProtocol";
    private File baseDirectory;
    private List<Valve> contextValves = new ArrayList<Valve>();
    private List<LifecycleListener> contextLifecycleListeners = new ArrayList<LifecycleListener>();
    private List<TomcatContextCustomizer> tomcatContextCustomizers = new ArrayList<TomcatContextCustomizer>();
    private List<TomcatConnectorCustomizer> tomcatConnectorCustomizers = new ArrayList<TomcatConnectorCustomizer>();
    private List<Connector> additionalTomcatConnectors = new ArrayList<Connector>();
    private ResourceLoader resourceLoader;
    private String protocol = "org.apache.coyote.http11.Http11NioProtocol";
    private String tldSkip;
    private String uriEncoding = "UTF-8";

    public TomcatEmbeddedServletContainerFactory() {
    }

    public TomcatEmbeddedServletContainerFactory(int port) {
        super(port);
    }

    public TomcatEmbeddedServletContainerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    @Override
    public EmbeddedServletContainer getEmbeddedServletContainer(ServletContextInitializer ... initializers) {
        Tomcat tomcat = new Tomcat();
        File baseDir = this.baseDirectory != null ? this.baseDirectory : this.createTempDir("tomcat");
        tomcat.setBaseDir(baseDir.getAbsolutePath());
        Connector connector = new Connector(this.protocol);
        tomcat.getService().addConnector(connector);
        this.customizeConnector(connector);
        tomcat.setConnector(connector);
        tomcat.getHost().setAutoDeploy(false);
        tomcat.getEngine().setBackgroundProcessorDelay(-1);
        for (Connector additionalConnector : this.additionalTomcatConnectors) {
            tomcat.getService().addConnector(additionalConnector);
        }
        this.prepareContext(tomcat.getHost(), initializers);
        this.logger.info((Object)("Server initialized with port: " + this.getPort()));
        return this.getTomcatEmbeddedServletContainer(tomcat);
    }

    protected void prepareContext(Host host, ServletContextInitializer[] initializers) {
        File docBase = this.getValidDocumentRoot();
        docBase = docBase != null ? docBase : this.createTempDir("tomcat-docbase");
        TomcatEmbeddedContext context = new TomcatEmbeddedContext();
        context.setName(this.getContextPath());
        context.setPath(this.getContextPath());
        context.setDocBase(docBase.getAbsolutePath());
        context.addLifecycleListener((LifecycleListener)new Tomcat.FixContextListener());
        context.setParentClassLoader(this.resourceLoader != null ? this.resourceLoader.getClassLoader() : ClassUtils.getDefaultClassLoader());
        SkipPatternJarScanner.apply(context, this.tldSkip);
        WebappLoader loader = new WebappLoader(context.getParentClassLoader());
        loader.setLoaderClass(TomcatEmbeddedWebappClassLoader.class.getName());
        loader.setDelegate(true);
        context.setLoader((Loader)loader);
        if (this.isRegisterDefaultServlet()) {
            this.addDefaultServlet((Context)context);
        }
        if (this.isRegisterJspServlet() && ClassUtils.isPresent((String)this.getJspServletClassName(), (ClassLoader)this.getClass().getClassLoader())) {
            this.addJspServlet((Context)context);
            this.addJasperInitializer(context);
            context.addLifecycleListener(new StoreMergedWebXmlListener());
        }
        ServletContextInitializer[] initializersToUse = this.mergeInitializers(initializers);
        this.configureContext((Context)context, initializersToUse);
        host.addChild((Container)context);
        this.postProcessContext((Context)context);
    }

    private void addDefaultServlet(Context context) {
        Wrapper defaultServlet = context.createWrapper();
        defaultServlet.setName("default");
        defaultServlet.setServletClass("org.apache.catalina.servlets.DefaultServlet");
        defaultServlet.addInitParameter("debug", "0");
        defaultServlet.addInitParameter("listings", "false");
        defaultServlet.setLoadOnStartup(1);
        defaultServlet.setOverridable(true);
        context.addChild((Container)defaultServlet);
        context.addServletMapping("/", "default");
    }

    private void addJspServlet(Context context) {
        Wrapper jspServlet = context.createWrapper();
        jspServlet.setName("jsp");
        jspServlet.setServletClass(this.getJspServletClassName());
        jspServlet.addInitParameter("fork", "false");
        jspServlet.setLoadOnStartup(3);
        context.addChild((Container)jspServlet);
        context.addServletMapping("*.jsp", "jsp");
        context.addServletMapping("*.jspx", "jsp");
    }

    private void addJasperInitializer(TomcatEmbeddedContext context) {
        try {
            ServletContainerInitializer initializer = (ServletContainerInitializer)ClassUtils.forName((String)"org.apache.jasper.servlet.JasperInitializer", null).newInstance();
            context.addServletContainerInitializer(initializer, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void customizeConnector(Connector connector) {
        int port = this.getPort() >= 0 ? this.getPort() : 0;
        connector.setPort(port);
        if (connector.getProtocolHandler() instanceof AbstractProtocol && this.getAddress() != null) {
            ((AbstractProtocol)connector.getProtocolHandler()).setAddress(this.getAddress());
        }
        if (this.getUriEncoding() != null) {
            connector.setURIEncoding(this.getUriEncoding());
        }
        connector.setProperty("bindOnInit", "false");
        for (TomcatConnectorCustomizer customizer : this.tomcatConnectorCustomizers) {
            customizer.customize(connector);
        }
    }

    protected void configureContext(Context context, ServletContextInitializer[] initializers) {
        ServletContextInitializerLifecycleListener starter = new ServletContextInitializerLifecycleListener(initializers);
        if (context instanceof TomcatEmbeddedContext) {
            ((TomcatEmbeddedContext)context).setStarter(starter);
        }
        context.addLifecycleListener((LifecycleListener)starter);
        for (LifecycleListener lifecycleListener : this.contextLifecycleListeners) {
            context.addLifecycleListener(lifecycleListener);
        }
        for (Valve valve : this.contextValves) {
            context.getPipeline().addValve(valve);
        }
        for (ErrorPage errorPage : this.getErrorPages()) {
            new TomcatErrorPage(errorPage).addToContext(context);
        }
        for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
            context.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
        }
        long timeout = this.getSessionTimeout();
        if (timeout > 0L) {
            timeout = Math.max(TimeUnit.SECONDS.toMinutes(timeout), 1L);
        }
        context.setSessionTimeout((int)timeout);
        for (TomcatContextCustomizer customizer : this.tomcatContextCustomizers) {
            customizer.customize(context);
        }
    }

    protected void postProcessContext(Context context) {
    }

    protected TomcatEmbeddedServletContainer getTomcatEmbeddedServletContainer(Tomcat tomcat) {
        return new TomcatEmbeddedServletContainer(tomcat, this.getPort() >= 0);
    }

    private File createTempDir(String prefix) {
        try {
            File tempFolder = File.createTempFile(prefix + ".", "." + this.getPort());
            tempFolder.delete();
            tempFolder.mkdir();
            tempFolder.deleteOnExit();
            return tempFolder;
        }
        catch (IOException ex) {
            throw new EmbeddedServletContainerException("Unable to create Tomcat tempdir", ex);
        }
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setTldSkip(String tldSkip) {
        Assert.notNull((Object)tldSkip, (String)"TldSkip must not be null");
        this.tldSkip = tldSkip;
    }

    public void setProtocol(String protocol) {
        Assert.hasLength((String)protocol, (String)"Protocol must not be empty");
        this.protocol = protocol;
    }

    public void setContextValves(Collection<? extends Valve> contextValves) {
        Assert.notNull(contextValves, (String)"Valves must not be null");
        this.contextValves = new ArrayList<Valve>(contextValves);
    }

    public Collection<Valve> getValves() {
        return this.contextValves;
    }

    public void addContextValves(Valve ... contextValves) {
        Assert.notNull((Object)contextValves, (String)"Valves must not be null");
        this.contextValves.addAll(Arrays.asList(contextValves));
    }

    public void setContextLifecycleListeners(Collection<? extends LifecycleListener> contextLifecycleListeners) {
        Assert.notNull(contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners = new ArrayList<LifecycleListener>(contextLifecycleListeners);
    }

    public Collection<LifecycleListener> getContextLifecycleListeners() {
        return this.contextLifecycleListeners;
    }

    public void addContextLifecycleListeners(LifecycleListener ... contextLifecycleListeners) {
        Assert.notNull((Object)contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners.addAll(Arrays.asList(contextLifecycleListeners));
    }

    public void setTomcatContextCustomizers(Collection<? extends TomcatContextCustomizer> tomcatContextCustomizers) {
        Assert.notNull(tomcatContextCustomizers, (String)"TomcatContextCustomizers must not be null");
        this.tomcatContextCustomizers = new ArrayList<TomcatContextCustomizer>(tomcatContextCustomizers);
    }

    public Collection<TomcatContextCustomizer> getTomcatContextCustomizers() {
        return this.tomcatContextCustomizers;
    }

    public void addContextCustomizers(TomcatContextCustomizer ... tomcatContextCustomizers) {
        Assert.notNull((Object)tomcatContextCustomizers, (String)"TomcatContextCustomizers must not be null");
        this.tomcatContextCustomizers.addAll(Arrays.asList(tomcatContextCustomizers));
    }

    public void setTomcatConnectorCustomizers(Collection<? extends TomcatConnectorCustomizer> tomcatConnectorCustomizers) {
        Assert.notNull(tomcatConnectorCustomizers, (String)"TomcatConnectorCustomizers must not be null");
        this.tomcatConnectorCustomizers = new ArrayList<TomcatConnectorCustomizer>(tomcatConnectorCustomizers);
    }

    public void addConnectorCustomizers(TomcatConnectorCustomizer ... tomcatConnectorCustomizers) {
        Assert.notNull((Object)tomcatConnectorCustomizers, (String)"TomcatConnectorCustomizers must not be null");
        this.tomcatConnectorCustomizers.addAll(Arrays.asList(tomcatConnectorCustomizers));
    }

    public Collection<TomcatConnectorCustomizer> getTomcatConnectorCustomizers() {
        return this.tomcatConnectorCustomizers;
    }

    public void addAdditionalTomcatConnectors(Connector ... connectors) {
        Assert.notNull((Object)connectors, (String)"Connectors must not be null");
        this.additionalTomcatConnectors.addAll(Arrays.asList(connectors));
    }

    public List<Connector> getAdditionalTomcatConnectors() {
        return this.additionalTomcatConnectors;
    }

    public void setUriEncoding(String uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public String getUriEncoding() {
        return this.uriEncoding;
    }

    private static class StoreMergedWebXmlListener
    implements LifecycleListener {
        private final String MERGED_WEB_XML = "org.apache.tomcat.util.scan.MergedWebXml";

        private StoreMergedWebXmlListener() {
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("configure_start")) {
                this.onStart((Context)event.getLifecycle());
            }
        }

        private void onStart(Context context) {
            ServletContext servletContext = context.getServletContext();
            if (servletContext.getAttribute(this.MERGED_WEB_XML) == null) {
                servletContext.setAttribute(this.MERGED_WEB_XML, (Object)this.getEmptyWebXml());
            }
            TomcatResources.get(context).addClasspathResources();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getEmptyWebXml() {
            String string;
            InputStream stream = TomcatEmbeddedServletContainerFactory.class.getResourceAsStream("empty-web.xml");
            Assert.state((stream != null ? 1 : 0) != 0, (String)"Unable to read empty web.xml");
            try {
                string = StreamUtils.copyToString((InputStream)stream, (Charset)Charset.forName("UTF-8"));
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            stream.close();
            return string;
        }
    }

    private static class TomcatErrorPage {
        private final String location;
        private final String exceptionType;
        private final int errorCode;
        private final Object nativePage;

        public TomcatErrorPage(ErrorPage errorPage) {
            this.location = errorPage.getPath();
            this.exceptionType = errorPage.getExceptionName();
            this.errorCode = errorPage.getStatusCode();
            this.nativePage = this.createNativePage(errorPage);
        }

        private Object createNativePage(ErrorPage errorPage) {
            Object nativePage = null;
            try {
                if (ClassUtils.isPresent((String)"org.apache.catalina.deploy.ErrorPage", null)) {
                    nativePage = new org.apache.catalina.deploy.ErrorPage();
                } else if (ClassUtils.isPresent((String)"org.apache.tomcat.util.descriptor.web.ErrorPage", null)) {
                    nativePage = BeanUtils.instantiate((Class)ClassUtils.forName((String)"org.apache.tomcat.util.descriptor.web.ErrorPage", null));
                }
            }
            catch (ClassNotFoundException ex) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            return nativePage;
        }

        public void addToContext(Context context) {
            Assert.state((this.nativePage != null ? 1 : 0) != 0, (String)"Neither Tomcat 7 nor 8 detected so no native error page exists");
            if (ClassUtils.isPresent((String)"org.apache.catalina.deploy.ErrorPage", null)) {
                org.apache.catalina.deploy.ErrorPage errorPage = (org.apache.catalina.deploy.ErrorPage)this.nativePage;
                errorPage.setLocation(this.location);
                errorPage.setErrorCode(this.errorCode);
                errorPage.setExceptionType(this.exceptionType);
                context.addErrorPage(errorPage);
            } else {
                this.callMethod(this.nativePage, "setLocation", this.location, String.class);
                this.callMethod(this.nativePage, "setErrorCode", this.errorCode, Integer.TYPE);
                this.callMethod(this.nativePage, "setExceptionType", this.exceptionType, String.class);
                this.callMethod(context, "addErrorPage", this.nativePage, this.nativePage.getClass());
            }
        }

        private void callMethod(Object target, String name, Object value, Class<?> type) {
            Method method = ReflectionUtils.findMethod(target.getClass(), (String)name, (Class[])new Class[]{type});
            ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])new Object[]{value});
        }
    }
}

