/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class ConfigurationBeanFactoryMetaData
implements BeanFactoryPostProcessor {
    private ConfigurableListableBeanFactory beanFactory;
    private Map<String, MetaData> beans = new HashMap<String, MetaData>();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        for (String name : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition definition = beanFactory.getBeanDefinition(name);
            String method = definition.getFactoryMethodName();
            String bean = definition.getFactoryBeanName();
            if (method == null || bean == null) continue;
            this.beans.put(name, new MetaData(bean, method));
        }
    }

    public <A extends Annotation> Map<String, Object> getBeansWithFactoryAnnotation(Class<A> type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String name : this.beans.keySet()) {
            if (this.findFactoryAnnotation(name, type) == null) continue;
            result.put(name, this.beanFactory.getBean(name));
        }
        return result;
    }

    public <A extends Annotation> A findFactoryAnnotation(String beanName, Class<A> type) {
        Method method = this.findFactoryMethod(beanName);
        if (method != null) {
            return (A)AnnotationUtils.findAnnotation((Method)method, type);
        }
        return null;
    }

    private Method findFactoryMethod(String beanName) {
        if (!this.beans.containsKey(beanName)) {
            return null;
        }
        final AtomicReference found = new AtomicReference();
        MetaData meta = this.beans.get(beanName);
        final String factory = meta.getMethod();
        Class type = this.beanFactory.getType(meta.getBean());
        ReflectionUtils.doWithMethods((Class)type, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                if (method.getName().equals(factory)) {
                    found.set(method);
                }
            }
        });
        return (Method)found.get();
    }

    private static class MetaData {
        private String bean;
        private String method;

        public MetaData(String bean, String method) {
            this.bean = bean;
            this.method = method;
        }

        public String getBean() {
            return this.bean;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

