/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedContext;
import org.springframework.util.Assert;

public class TomcatEmbeddedServletContainer
implements EmbeddedServletContainer {
    private final Log logger = LogFactory.getLog(TomcatEmbeddedServletContainer.class);
    private static AtomicInteger containerCounter = new AtomicInteger(-1);
    private final Tomcat tomcat;
    private final Map<Service, Connector[]> serviceConnectors = new HashMap<Service, Connector[]>();
    private final boolean autoStart;

    public TomcatEmbeddedServletContainer(Tomcat tomcat) {
        this(tomcat, true);
    }

    public TomcatEmbeddedServletContainer(Tomcat tomcat, boolean autoStart) {
        Assert.notNull((Object)tomcat, (String)"Tomcat Server must not be null");
        this.tomcat = tomcat;
        this.autoStart = autoStart;
        this.initialize();
    }

    private synchronized void initialize() throws EmbeddedServletContainerException {
        this.logger.info((Object)("Tomcat initialized with port(s): " + this.getConfiguredPortsDescription()));
        try {
            this.addInstanceIdToEngineName();
            this.removeServiceConnectors();
            this.tomcat.start();
            this.rethrowDeferredStartupExceptions();
            this.startDaemonAwaitThread();
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to start embedded Tomcat", ex);
        }
    }

    private String getConfiguredPortsDescription() {
        StringBuilder ports = new StringBuilder();
        for (Connector connector : this.tomcat.getService().findConnectors()) {
            ports.append(ports.length() == 0 ? "" : " ");
            ports.append(connector.getPort() + "/" + connector.getScheme());
        }
        return ports.toString();
    }

    private void addInstanceIdToEngineName() {
        int instanceId = containerCounter.incrementAndGet();
        if (instanceId > 0) {
            Engine engine = this.tomcat.getEngine();
            engine.setName(engine.getName() + "-" + instanceId);
        }
    }

    private void removeServiceConnectors() {
        for (Service service : this.tomcat.getServer().findServices()) {
            Connector[] connectors = (Connector[])service.findConnectors().clone();
            this.serviceConnectors.put(service, connectors);
            for (Connector connector : connectors) {
                service.removeConnector(connector);
            }
        }
    }

    private void rethrowDeferredStartupExceptions() throws Exception {
        Container[] children;
        for (Container container : children = this.tomcat.getHost().findChildren()) {
            Exception exception;
            if (!(container instanceof TomcatEmbeddedContext) || (exception = ((TomcatEmbeddedContext)container).getStarter().getStartUpException()) == null) continue;
            throw exception;
        }
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread("container-" + containerCounter.get()){

            @Override
            public void run() {
                TomcatEmbeddedServletContainer.this.tomcat.getServer().await();
            }
        };
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    @Override
    public void start() throws EmbeddedServletContainerException {
        this.addPreviouslyRemovedConnectors();
        Connector connector = this.tomcat.getConnector();
        if (connector != null && this.autoStart) {
            this.startConnector(connector);
        }
        if (this.connectorsHaveFailedToStart()) {
            this.stopSilently();
            throw new IllegalStateException("Tomcat connector in failed state");
        }
        this.logger.info((Object)("Tomcat started on port(s): " + this.getActualPortsDescription()));
    }

    private boolean connectorsHaveFailedToStart() {
        for (Connector connector : this.tomcat.getService().findConnectors()) {
            if (!LifecycleState.FAILED.equals((Object)connector.getState())) continue;
            return true;
        }
        return false;
    }

    private void stopSilently() {
        try {
            this.tomcat.stop();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    private void addPreviouslyRemovedConnectors() {
        Service[] services;
        for (Service service : services = this.tomcat.getServer().findServices()) {
            Connector[] connectors = this.serviceConnectors.get(service);
            if (connectors == null) continue;
            for (Connector connector : connectors) {
                service.addConnector(connector);
                if (this.autoStart) continue;
                this.stopProtocolHandler(connector);
            }
            this.serviceConnectors.remove(service);
        }
    }

    private void stopProtocolHandler(Connector connector) {
        try {
            connector.getProtocolHandler().stop();
        }
        catch (Exception ex) {
            this.logger.error((Object)"Cannot pause connector: ", (Throwable)ex);
        }
    }

    private void startConnector(Connector connector) {
        try {
            for (Container child : this.tomcat.getHost().findChildren()) {
                if (!(child instanceof TomcatEmbeddedContext)) continue;
                ((TomcatEmbeddedContext)child).deferredLoadOnStartup();
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Cannot start connector: ", (Throwable)ex);
            throw new EmbeddedServletContainerException("Unable to start embedded Tomcat connectors", ex);
        }
    }

    Map<Service, Connector[]> getServiceConnectors() {
        return this.serviceConnectors;
    }

    private String getActualPortsDescription() {
        StringBuilder ports = new StringBuilder();
        for (Connector connector : this.tomcat.getService().findConnectors()) {
            ports.append(ports.length() == 0 ? "" : " ");
            ports.append(connector.getLocalPort() + "/" + connector.getScheme());
        }
        return ports.toString();
    }

    @Override
    public synchronized void stop() throws EmbeddedServletContainerException {
        try {
            try {
                this.tomcat.stop();
                this.tomcat.destroy();
            }
            catch (LifecycleException ex) {
                // empty catch block
            }
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to stop embedded Tomcat", ex);
        }
        finally {
            containerCounter.decrementAndGet();
        }
    }

    @Override
    public int getPort() {
        Connector connector = this.tomcat.getConnector();
        if (connector != null) {
            return connector.getLocalPort();
        }
        return 0;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }
}

