/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.yaml;

import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.util.StringUtils;

public class ArrayDocumentMatcher
implements YamlProcessor.DocumentMatcher {
    private final String key;
    private final String[] patterns;

    public ArrayDocumentMatcher(String key, String ... patterns) {
        this.key = key;
        this.patterns = patterns;
    }

    public YamlProcessor.MatchStatus matches(Properties properties) {
        if (!properties.containsKey(this.key)) {
            return YamlProcessor.MatchStatus.ABSTAIN;
        }
        Set<String> values = StringUtils.commaDelimitedListToSet((String)properties.getProperty(this.key));
        if (values.isEmpty()) {
            values = Collections.singleton("");
        }
        for (String pattern : this.patterns) {
            for (String value : values) {
                if (!value.matches(pattern)) continue;
                return YamlProcessor.MatchStatus.FOUND;
            }
        }
        return YamlProcessor.MatchStatus.NOT_FOUND;
    }
}

