/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.util.Collection;
import java.util.List;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.IndexedElementsBinder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ResolvableType;

class CollectionBinder
extends IndexedElementsBinder<Collection<Object>> {
    CollectionBinder(BindContext context) {
        super(context);
    }

    @Override
    protected Object bindAggregate(ConfigurationPropertyName name, Bindable<?> target, AggregateElementBinder elementBinder) {
        Class collectionType = target.getValue() == null ? target.getType().resolve() : List.class;
        IndexedElementsBinder.IndexedCollectionSupplier collection = new IndexedElementsBinder.IndexedCollectionSupplier(() -> CollectionFactory.createCollection((Class)collectionType, (int)0));
        ResolvableType elementType = target.getType().asCollection().getGeneric(new int[0]);
        ResolvableType aggregateType = ResolvableType.forClassWithGenerics(List.class, (ResolvableType[])target.getType().asCollection().getGenerics());
        this.bindIndexed(name, target, elementBinder, collection, aggregateType, elementType);
        if (collection.wasSupplied()) {
            return collection.get();
        }
        return null;
    }

    @Override
    protected Collection<Object> merge(Collection<Object> existing, Collection<Object> additional) {
        try {
            existing.clear();
            existing.addAll(additional);
            return existing;
        }
        catch (UnsupportedOperationException ex) {
            return this.createNewCollection(additional);
        }
    }

    private Collection<Object> createNewCollection(Collection<Object> additional) {
        Collection merged = CollectionFactory.createCollection(additional.getClass(), (int)additional.size());
        merged.addAll(additional);
        return merged;
    }
}

