/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.BeanBinder;
import org.springframework.boot.context.properties.bind.BeanPropertyBinder;
import org.springframework.boot.context.properties.bind.BeanPropertyName;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.core.ResolvableType;

class JavaBeanBinder
implements BeanBinder {
    JavaBeanBinder() {
    }

    @Override
    public <T> T bind(ConfigurationPropertyName name, Bindable<T> target, BindContext context, BeanPropertyBinder propertyBinder) {
        boolean hasKnownBindableProperties = context.streamSources().anyMatch(s -> s.containsDescendantOf(name) == ConfigurationPropertyState.PRESENT);
        Bean<T> bean = Bean.get(target, hasKnownBindableProperties);
        if (bean == null) {
            return null;
        }
        BeanSupplier<T> beanSupplier = bean.getSupplier(target);
        boolean bound = this.bind(propertyBinder, bean, beanSupplier);
        return bound ? (T)beanSupplier.get() : null;
    }

    private <T> boolean bind(BeanPropertyBinder propertyBinder, Bean<T> bean, BeanSupplier<T> beanSupplier) {
        boolean bound = false;
        for (Map.Entry<String, BeanProperty> entry : bean.getProperties().entrySet()) {
            bound |= this.bind(beanSupplier, propertyBinder, entry.getValue());
        }
        return bound;
    }

    private <T> boolean bind(BeanSupplier<T> beanSupplier, BeanPropertyBinder propertyBinder, BeanProperty property) {
        String propertyName = property.getName();
        ResolvableType type = property.getType();
        Supplier<Object> value = property.getValue(beanSupplier);
        Annotation[] annotations = property.getAnnotations();
        Object bound = propertyBinder.bindProperty(propertyName, Bindable.of(type).withSuppliedValue(value).withAnnotations(annotations));
        if (bound == null) {
            return false;
        }
        if (property.isSettable()) {
            property.setValue(beanSupplier, bound);
        } else if (value == null || !bound.equals(value.get())) {
            throw new IllegalStateException("No setter found for property: " + property.getName());
        }
        return true;
    }

    private static class BeanProperty {
        private final String name;
        private Method getter;
        private Method setter;
        private Field field;

        BeanProperty(String name) {
            this.name = BeanPropertyName.toDashedForm(name);
        }

        public void addGetter(Method getter) {
            if (this.getter == null) {
                this.getter = getter;
            }
        }

        public void addSetter(Method setter) {
            if (this.setter == null) {
                this.setter = setter;
            }
        }

        public void addField(Field field) {
            if (this.field == null) {
                this.field = field;
            }
        }

        public String getName() {
            return this.name;
        }

        public ResolvableType getType() {
            if (this.setter != null) {
                return ResolvableType.forMethodParameter((Method)this.setter, (int)0);
            }
            return ResolvableType.forMethodReturnType((Method)this.getter);
        }

        public Annotation[] getAnnotations() {
            try {
                return this.field == null ? null : this.field.getDeclaredAnnotations();
            }
            catch (Exception ex) {
                return null;
            }
        }

        public Supplier<Object> getValue(Supplier<?> instance) {
            if (this.getter == null) {
                return null;
            }
            return () -> {
                try {
                    this.getter.setAccessible(true);
                    return this.getter.invoke(instance.get(), new Object[0]);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Unable to get value for property " + this.name, ex);
                }
            };
        }

        public boolean isSettable() {
            return this.setter != null;
        }

        public void setValue(Supplier<?> instance, Object value) {
            try {
                this.setter.setAccessible(true);
                this.setter.invoke(instance.get(), value);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to set value for property " + this.name, ex);
            }
        }
    }

    private static class BeanSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> factory;
        private T instance;

        BeanSupplier(Supplier<T> factory) {
            this.factory = factory;
        }

        @Override
        public T get() {
            if (this.instance == null) {
                this.instance = this.factory.get();
            }
            return this.instance;
        }
    }

    private static class Bean<T> {
        private static Bean<?> cached;
        private final Class<?> type;
        private final Map<String, BeanProperty> properties = new LinkedHashMap<String, BeanProperty>();

        Bean(Class<?> type) {
            this.type = type;
            this.putProperties(type);
        }

        private void putProperties(Class<?> type) {
            while (type != null && !Object.class.equals(type)) {
                for (Method method : type.getDeclaredMethods()) {
                    if (!this.isCandidate(method)) continue;
                    this.addMethod(method);
                }
                for (AccessibleObject accessibleObject : type.getDeclaredFields()) {
                    this.addField((Field)accessibleObject);
                }
                type = type.getSuperclass();
            }
        }

        private boolean isCandidate(Method method) {
            return Modifier.isPublic(method.getModifiers()) && !Object.class.equals(method.getDeclaringClass()) && !Class.class.equals(method.getDeclaringClass());
        }

        private void addMethod(Method method) {
            String name = method.getName();
            int parameterCount = method.getParameterCount();
            if (name.startsWith("get") && parameterCount == 0) {
                name = Introspector.decapitalize(name.substring(3));
                this.properties.computeIfAbsent(name, BeanProperty::new).addGetter(method);
            } else if (name.startsWith("is") && parameterCount == 0) {
                name = Introspector.decapitalize(name.substring(2));
                this.properties.computeIfAbsent(name, BeanProperty::new).addGetter(method);
            } else if (name.startsWith("set") && parameterCount == 1) {
                name = Introspector.decapitalize(name.substring(3));
                this.properties.computeIfAbsent(name, BeanProperty::new).addSetter(method);
            }
        }

        private void addField(Field field) {
            BeanProperty property = this.properties.get(field.getName());
            if (property != null) {
                property.addField(field);
            }
        }

        public Class<?> getType() {
            return this.type;
        }

        public Map<String, BeanProperty> getProperties() {
            return this.properties;
        }

        public BeanSupplier<T> getSupplier(Bindable<T> target) {
            return new BeanSupplier<Object>(() -> {
                Object instance = null;
                if (target.getValue() != null) {
                    instance = target.getValue().get();
                }
                if (instance == null) {
                    instance = BeanUtils.instantiateClass(this.type);
                }
                return instance;
            });
        }

        public static <T> Bean<T> get(Bindable<T> bindable, boolean canCallGetValue) {
            Class<?> type = bindable.getType().resolve();
            Supplier<T> value = bindable.getValue();
            Object instance = null;
            if (canCallGetValue && value != null) {
                instance = value.get();
                Class<?> clazz = type = instance != null ? instance.getClass() : type;
            }
            if (instance == null && !Bean.isInstantiable(type)) {
                return null;
            }
            Bean<Object> bean = cached;
            if (bean == null || !type.equals(bean.getType())) {
                bean = new Bean<T>(type);
                cached = bean;
            }
            return bean;
        }

        private static boolean isInstantiable(Class<?> type) {
            if (type.isInterface()) {
                return false;
            }
            try {
                type.getDeclaredConstructor(new Class[0]);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

