/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.info;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Properties;
import org.springframework.boot.info.InfoProperties;

public class GitProperties
extends InfoProperties {
    public GitProperties(Properties entries) {
        super(GitProperties.processEntries(entries));
    }

    public String getBranch() {
        return this.get("branch");
    }

    public String getCommitId() {
        return this.get("commit.id");
    }

    public String getShortCommitId() {
        String shortId = this.get("commit.id.abbrev");
        if (shortId != null) {
            return shortId;
        }
        String id = this.getCommitId();
        if (id == null) {
            return null;
        }
        return id.length() > 7 ? id.substring(0, 7) : id;
    }

    public Instant getCommitTime() {
        return this.getInstant("commit.time");
    }

    private static Properties processEntries(Properties properties) {
        GitProperties.coercePropertyToEpoch(properties, "commit.time");
        GitProperties.coercePropertyToEpoch(properties, "build.time");
        return properties;
    }

    private static void coercePropertyToEpoch(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value != null) {
            properties.setProperty(key, GitProperties.coerceToEpoch(value));
        }
    }

    private static String coerceToEpoch(String s) {
        Long epoch = GitProperties.parseEpochSecond(s);
        if (epoch != null) {
            return String.valueOf(epoch);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        try {
            return String.valueOf(format.parse(s).getTime());
        }
        catch (ParseException ex) {
            return s;
        }
    }

    private static Long parseEpochSecond(String s) {
        try {
            return Long.parseLong(s) * 1000L;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

