/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.servlet;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class ApplicationContextRequestMatcher<C>
implements RequestMatcher {
    private final Class<? extends C> contextClass;
    private volatile C context;
    private final Object contextLock = new Object();

    public ApplicationContextRequestMatcher(Class<? extends C> contextClass) {
        Assert.notNull(contextClass, (String)"Context class must not be null");
        this.contextClass = contextClass;
    }

    public final boolean matches(HttpServletRequest request) {
        return this.matches(request, this.getContext(request));
    }

    protected abstract boolean matches(HttpServletRequest var1, C var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C getContext(HttpServletRequest request) {
        if (this.context == null) {
            Object object = this.contextLock;
            synchronized (object) {
                if (this.context == null) {
                    this.context = this.createContext(request);
                    this.initialized(this.context);
                }
            }
        }
        return this.context;
    }

    protected void initialized(C context) {
    }

    private C createContext(HttpServletRequest request) {
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getServletContext());
        if (this.contextClass.isInstance(context)) {
            return (C)context;
        }
        try {
            return (C)context.getBean(this.contextClass);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return (C)context.getAutowireCapableBeanFactory().createBean(this.contextClass, 3, false);
        }
    }
}

