/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.Formatter;

class ConversionServiceDeducer {
    private final ApplicationContext applicationContext;

    ConversionServiceDeducer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ConversionService getConversionService() {
        try {
            return (ConversionService)this.applicationContext.getBean("conversionService", ConversionService.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return new Factory((BeanFactory)this.applicationContext.getAutowireCapableBeanFactory()).create();
        }
    }

    private static class Factory {
        private final List<Converter> converters;
        private final List<GenericConverter> genericConverters;
        private final List<Formatter> formatters;

        Factory(BeanFactory beanFactory) {
            this.converters = this.beans(beanFactory, Converter.class, "org.springframework.boot.context.properties.ConfigurationPropertiesBinding");
            this.genericConverters = this.beans(beanFactory, GenericConverter.class, "org.springframework.boot.context.properties.ConfigurationPropertiesBinding");
            this.formatters = this.beans(beanFactory, Formatter.class, "org.springframework.boot.context.properties.ConfigurationPropertiesBinding");
        }

        private <T> List<T> beans(BeanFactory beanFactory, Class<T> type, String qualifier) {
            if (beanFactory instanceof ListableBeanFactory) {
                return this.beans(type, qualifier, (ListableBeanFactory)beanFactory);
            }
            return Collections.emptyList();
        }

        private <T> List<T> beans(Class<T> type, String qualifier, ListableBeanFactory beanFactory) {
            return new ArrayList(BeanFactoryAnnotationUtils.qualifiedBeansOfType((ListableBeanFactory)beanFactory, type, (String)qualifier).values());
        }

        public ConversionService create() {
            if (this.converters.isEmpty() && this.genericConverters.isEmpty() && this.formatters.isEmpty()) {
                return ApplicationConversionService.getSharedInstance();
            }
            ApplicationConversionService conversionService = new ApplicationConversionService();
            for (Converter converter : this.converters) {
                conversionService.addConverter(converter);
            }
            for (GenericConverter genericConverter : this.genericConverters) {
                conversionService.addConverter(genericConverter);
            }
            for (Formatter formatter : this.formatters) {
                conversionService.addFormatter(formatter);
            }
            return conversionService;
        }
    }
}

