/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.CallerDataConverter;
import ch.qos.logback.classic.pattern.ClassOfCallerConverter;
import ch.qos.logback.classic.pattern.ContextNameConverter;
import ch.qos.logback.classic.pattern.DateConverter;
import ch.qos.logback.classic.pattern.ExtendedThrowableProxyConverter;
import ch.qos.logback.classic.pattern.FileOfCallerConverter;
import ch.qos.logback.classic.pattern.LevelConverter;
import ch.qos.logback.classic.pattern.LineOfCallerConverter;
import ch.qos.logback.classic.pattern.LineSeparatorConverter;
import ch.qos.logback.classic.pattern.LocalSequenceNumberConverter;
import ch.qos.logback.classic.pattern.LoggerConverter;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.pattern.MarkerConverter;
import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.pattern.MethodOfCallerConverter;
import ch.qos.logback.classic.pattern.NopThrowableInformationConverter;
import ch.qos.logback.classic.pattern.PropertyConverter;
import ch.qos.logback.classic.pattern.RelativeTimeConverter;
import ch.qos.logback.classic.pattern.RootCauseFirstThrowableProxyConverter;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.pattern.ThreadConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.IntegerTokenConverter;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.boot.logging.logback.ColorConverter;
import org.springframework.boot.logging.logback.ExtendedWhitespaceThrowableProxyConverter;
import org.springframework.boot.logging.logback.WhitespaceThrowableProxyConverter;
import org.springframework.util.ClassUtils;

class LogbackRuntimeHintsRegistrar
implements RuntimeHintsRegistrar {
    LogbackRuntimeHintsRegistrar() {
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        if (!ClassUtils.isPresent((String)"ch.qos.logback.classic.LoggerContext", (ClassLoader)classLoader)) {
            return;
        }
        ReflectionHints reflection = hints.reflection();
        this.registerHintsForLogbackLoggingSystemTypeChecks(reflection);
        this.registerHintsForBuiltInLogbackConverters(reflection);
        this.registerHintsForSpringBootConverters(reflection);
    }

    private void registerHintsForLogbackLoggingSystemTypeChecks(ReflectionHints reflection) {
        Consumer<TypeHint.Builder> defaultHint = hint -> {};
        reflection.registerType(LoggerContext.class, defaultHint);
        reflection.registerType(SLF4JBridgeHandler.class, defaultHint);
    }

    private void registerHintsForBuiltInLogbackConverters(ReflectionHints reflection) {
        this.registerForPublicConstructorInvocation(reflection, CallerDataConverter.class, ClassOfCallerConverter.class, ContextNameConverter.class, DateConverter.class, DateTokenConverter.class, ExtendedThrowableProxyConverter.class, FileOfCallerConverter.class, IntegerTokenConverter.class, LevelConverter.class, LineOfCallerConverter.class, LineSeparatorConverter.class, LocalSequenceNumberConverter.class, LoggerConverter.class, MarkerConverter.class, MDCConverter.class, MessageConverter.class, MethodOfCallerConverter.class, NopThrowableInformationConverter.class, PropertyConverter.class, RelativeTimeConverter.class, RootCauseFirstThrowableProxyConverter.class, SyslogStartConverter.class, ThreadConverter.class, ThrowableProxyConverter.class);
    }

    private void registerHintsForSpringBootConverters(ReflectionHints reflection) {
        this.registerForPublicConstructorInvocation(reflection, ColorConverter.class, ExtendedWhitespaceThrowableProxyConverter.class, WhitespaceThrowableProxyConverter.class);
    }

    private void registerForPublicConstructorInvocation(ReflectionHints reflection, Class<?> ... classes) {
        reflection.registerTypes(this.typeReferences(classes), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS}));
    }

    private Iterable<TypeReference> typeReferences(Class<?> ... classes) {
        return Stream.of(classes).map(TypeReference::of).collect(Collectors.toList());
    }
}

