/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.net.Severity;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.springframework.boot.json.JsonWriter;
import org.springframework.boot.json.WritableJson;
import org.springframework.boot.logging.structured.GraylogExtendedLogFormatProperties;
import org.springframework.boot.logging.structured.JsonWriterStructuredLogFormatter;
import org.springframework.boot.logging.structured.StructureLoggingJsonMembersCustomizer;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class GraylogExtendedLogFormatStructuredLogFormatter
extends JsonWriterStructuredLogFormatter<LogEvent> {
    private static final Log logger = LogFactory.getLog(GraylogExtendedLogFormatStructuredLogFormatter.class);
    private static final Pattern FIELD_NAME_VALID_PATTERN = Pattern.compile("^[\\w.\\-]*$");
    private static final Set<String> ADDITIONAL_FIELD_ILLEGAL_KEYS = Set.of("id", "_id");

    GraylogExtendedLogFormatStructuredLogFormatter(Environment environment, StructureLoggingJsonMembersCustomizer<?> customizer) {
        super((JsonWriter.Members<E> members) -> GraylogExtendedLogFormatStructuredLogFormatter.jsonMembers(environment, members), customizer);
    }

    private static void jsonMembers(Environment environment, JsonWriter.Members<LogEvent> members) {
        members.add("version", "1.1");
        members.add("short_message", LogEvent::getMessage).as(GraylogExtendedLogFormatStructuredLogFormatter::getMessageText);
        members.add("timestamp", LogEvent::getInstant).as(GraylogExtendedLogFormatStructuredLogFormatter::formatTimeStamp);
        members.add("level", GraylogExtendedLogFormatStructuredLogFormatter::convertLevel);
        members.add("_level_name", LogEvent::getLevel).as(Level::name);
        members.add("_process_pid", (Long)environment.getProperty("spring.application.pid", Long.class)).when(Objects::nonNull);
        members.add("_process_thread_name", LogEvent::getThreadName);
        GraylogExtendedLogFormatProperties.get(environment).jsonMembers(members);
        members.add("_log_logger", LogEvent::getLoggerName);
        members.from(LogEvent::getContextData).whenNot(ReadOnlyStringMap::isEmpty).usingPairs(GraylogExtendedLogFormatStructuredLogFormatter::createAdditionalFields);
        members.add().whenNotNull(LogEvent::getThrownProxy).usingMembers(GraylogExtendedLogFormatStructuredLogFormatter::throwableMembers);
    }

    private static String getMessageText(Message message) {
        String formattedMessage = message.getFormattedMessage();
        return !StringUtils.hasText((String)formattedMessage) ? "(blank)" : formattedMessage;
    }

    private static WritableJson formatTimeStamp(Instant timeStamp) {
        return out -> out.append(new BigDecimal(timeStamp.getEpochMillisecond()).movePointLeft(3).toPlainString());
    }

    private static int convertLevel(LogEvent event) {
        return Severity.getSeverity((Level)event.getLevel()).getCode();
    }

    private static void throwableMembers(JsonWriter.Members<LogEvent> members) {
        members.add("full_message", GraylogExtendedLogFormatStructuredLogFormatter::formatFullMessageWithThrowable);
        members.add("_error_type", event -> event.getThrownProxy().getThrowable()).whenNotNull().as(ObjectUtils::nullSafeClassName);
        members.add("_error_stack_trace", event -> event.getThrownProxy().getExtendedStackTraceAsString());
        members.add("_error_message", event -> event.getThrownProxy().getMessage());
    }

    private static String formatFullMessageWithThrowable(LogEvent event) {
        return event.getMessage().getFormattedMessage() + "\n\n" + event.getThrownProxy().getExtendedStackTraceAsString();
    }

    private static void createAdditionalFields(ReadOnlyStringMap contextData, BiConsumer<Object, Object> pairs) {
        contextData.forEach((name, value) -> GraylogExtendedLogFormatStructuredLogFormatter.createAdditionalField(name, value, pairs));
    }

    private static void createAdditionalField(String name, Object value, BiConsumer<Object, Object> pairs) {
        Assert.notNull((Object)name, (String)"fieldName must not be null");
        if (!FIELD_NAME_VALID_PATTERN.matcher(name).matches()) {
            logger.warn((Object)LogMessage.format((String)"'%s' is not a valid field name according to GELF standard", (Object)name));
            return;
        }
        if (ADDITIONAL_FIELD_ILLEGAL_KEYS.contains(name)) {
            logger.warn((Object)LogMessage.format((String)"'%s' is an illegal field name according to GELF standard", (Object)name));
            return;
        }
        pairs.accept(GraylogExtendedLogFormatStructuredLogFormatter.asAdditionalFieldName(name), value);
    }

    private static Object asAdditionalFieldName(String name) {
        return !name.startsWith("_") ? "_" + name : name;
    }
}

