/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.logging.StackTracePrinter;
import org.springframework.util.Assert;

class Extractor {
    private final @Nullable StackTracePrinter stackTracePrinter;

    Extractor(@Nullable StackTracePrinter stackTracePrinter) {
        this.stackTracePrinter = stackTracePrinter;
    }

    String messageAndStackTrace(LogEvent event) {
        return event.getMessage().getFormattedMessage() + "\n\n" + this.stackTrace(event);
    }

    @Nullable String stackTrace(LogEvent event) {
        return this.stackTrace(event.getThrownProxy());
    }

    @Nullable String stackTrace(@Nullable ThrowableProxy throwableProxy) {
        if (throwableProxy == null) {
            return null;
        }
        if (this.stackTracePrinter != null) {
            Throwable throwable = throwableProxy.getThrowable();
            Assert.state((throwable != null ? 1 : 0) != 0, (String)"Proxy must return Throwable in order to print exception");
            return this.stackTracePrinter.printStackTraceToString(throwable);
        }
        return throwableProxy.getExtendedStackTraceAsString();
    }
}

