/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class SystemEnvironmentConfigDataResource
extends ConfigDataResource {
    private final String variableName;
    private final PropertySourceLoader loader;
    private final Function<String, @Nullable String> environment;

    SystemEnvironmentConfigDataResource(String variableName, PropertySourceLoader loader, Function<String, @Nullable String> environment) {
        this.variableName = variableName;
        this.loader = loader;
        this.environment = environment;
    }

    String getVariableName() {
        return this.variableName;
    }

    PropertySourceLoader getLoader() {
        return this.loader;
    }

    @Nullable List<PropertySource<?>> load() throws IOException {
        String content = this.environment.apply(this.variableName);
        return content != null ? this.loader.load(StringUtils.capitalize((String)this.toString()), (Resource)this.asResource(content)) : null;
    }

    private ByteArrayResource asResource(String content) {
        return new ByteArrayResource(content.getBytes(StandardCharsets.UTF_8));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SystemEnvironmentConfigDataResource other = (SystemEnvironmentConfigDataResource)obj;
        return Objects.equals(this.loader.getClass(), other.loader.getClass()) && Objects.equals(this.variableName, other.variableName);
    }

    public int hashCode() {
        return Objects.hash(this.variableName, this.loader.getClass());
    }

    public String toString() {
        return "system environment variable [" + this.variableName + "] content loaded using " + ClassUtils.getShortName(this.loader.getClass());
    }
}

