/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.pem;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.ssl.pem.PemSslStore;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.function.SingletonSupplier;

public class PemSslStoreBundle
implements SslStoreBundle {
    private static final String DEFAULT_ALIAS = "ssl";
    private final SingletonSupplier<KeyStore> keyStore = SingletonSupplier.of(() -> PemSslStoreBundle.createKeyStore("key", pemKeyStore));
    private final SingletonSupplier<KeyStore> trustStore = SingletonSupplier.of(() -> PemSslStoreBundle.createKeyStore("trust", pemTrustStore));

    public PemSslStoreBundle(@Nullable PemSslStoreDetails keyStoreDetails, @Nullable PemSslStoreDetails trustStoreDetails) {
        this(PemSslStore.load(keyStoreDetails), PemSslStore.load(trustStoreDetails));
    }

    public PemSslStoreBundle(@Nullable PemSslStore pemKeyStore, @Nullable PemSslStore pemTrustStore) {
    }

    @Override
    public @Nullable KeyStore getKeyStore() {
        return (KeyStore)this.keyStore.get();
    }

    @Override
    public @Nullable String getKeyStorePassword() {
        return null;
    }

    @Override
    public @Nullable KeyStore getTrustStore() {
        return (KeyStore)this.trustStore.get();
    }

    private static @Nullable KeyStore createKeyStore(String name, @Nullable PemSslStore pemSslStore) {
        if (pemSslStore == null) {
            return null;
        }
        try {
            List<X509Certificate> certificates = pemSslStore.certificates();
            Assert.state((!ObjectUtils.isEmpty(certificates) ? 1 : 0) != 0, (String)"Certificates must not be empty");
            String alias = PemSslStoreBundle.getAlias(pemSslStore);
            KeyStore store = PemSslStoreBundle.createKeyStore(pemSslStore.type());
            PrivateKey privateKey = pemSslStore.privateKey();
            if (privateKey != null) {
                PemSslStoreBundle.addPrivateKey(store, privateKey, alias, pemSslStore.password(), certificates);
            } else {
                PemSslStoreBundle.addCertificates(store, certificates, alias);
            }
            return store;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create %s store: %s".formatted(name, ex.getMessage()), ex);
        }
    }

    private static String getAlias(PemSslStore pemSslStore) {
        String alias = pemSslStore.alias();
        return alias != null ? alias : DEFAULT_ALIAS;
    }

    private static KeyStore createKeyStore(@Nullable String type) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store = KeyStore.getInstance(StringUtils.hasText((String)type) ? type : KeyStore.getDefaultType());
        store.load(null);
        return store;
    }

    private static void addPrivateKey(KeyStore keyStore, PrivateKey privateKey, String alias, @Nullable String keyPassword, List<X509Certificate> certificateChain) throws KeyStoreException {
        keyStore.setKeyEntry(alias, privateKey, keyPassword != null ? keyPassword.toCharArray() : null, (Certificate[])certificateChain.toArray(X509Certificate[]::new));
    }

    private static void addCertificates(KeyStore keyStore, List<X509Certificate> certificates, String alias) throws KeyStoreException {
        for (int index = 0; index < certificates.size(); ++index) {
            String entryAlias = alias + (String)(certificates.size() == 1 ? "" : "-" + index);
            X509Certificate certificate = certificates.get(index);
            keyStore.setCertificateEntry(entryAlias, certificate);
        }
    }

    public String toString() {
        ToStringCreator creator = new ToStringCreator((Object)this);
        KeyStore keyStore = (KeyStore)this.keyStore.get();
        KeyStore trustStore = (KeyStore)this.trustStore.get();
        creator.append("keyStore.type", (Object)(keyStore != null ? keyStore.getType() : "none"));
        creator.append("keyStorePassword", null);
        creator.append("trustStore.type", (Object)(trustStore != null ? trustStore.getType() : "none"));
        return creator.toString();
    }
}

