/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;

public enum WebApplicationType {
    NONE,
    SERVLET,
    REACTIVE;

    private static final String[] SERVLET_INDICATOR_CLASSES;

    public static WebApplicationType deduce() {
        for (Deducer deducer : SpringFactoriesLoader.forDefaultResourceLocation().load(Deducer.class)) {
            WebApplicationType deduced = deducer.deduceWebApplicationType();
            if (deduced == null) continue;
            return deduced;
        }
        return WebApplicationType.isServletApplication() ? SERVLET : NONE;
    }

    private static boolean isServletApplication() {
        for (String servletIndicatorClass : SERVLET_INDICATOR_CLASSES) {
            if (ClassUtils.isPresent((String)servletIndicatorClass, null)) continue;
            return false;
        }
        return true;
    }

    static {
        SERVLET_INDICATOR_CLASSES = new String[]{"jakarta.servlet.Servlet", "org.springframework.web.context.ConfigurableWebApplicationContext"};
    }

    @FunctionalInterface
    public static interface Deducer {
        public @Nullable WebApplicationType deduceWebApplicationType();
    }

    static class WebApplicationTypeRuntimeHints
    implements RuntimeHintsRegistrar {
        WebApplicationTypeRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            for (String servletIndicatorClass : SERVLET_INDICATOR_CLASSES) {
                this.registerTypeIfPresent(servletIndicatorClass, classLoader, hints);
            }
        }

        private void registerTypeIfPresent(String typeName, @Nullable ClassLoader classLoader, RuntimeHints hints) {
            if (ClassUtils.isPresent((String)typeName, (ClassLoader)classLoader)) {
                hints.reflection().registerType(TypeReference.of((String)typeName), new MemberCategory[0]);
            }
        }
    }
}

