/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.autoconfigure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.cloud.alibaba.dubbo.annotation.DubboTransported;
import org.springframework.cloud.alibaba.dubbo.client.loadbalancer.DubboMetadataInitializerInterceptor;
import org.springframework.cloud.alibaba.dubbo.client.loadbalancer.DubboTransporterInterceptor;
import org.springframework.cloud.alibaba.dubbo.metadata.repository.DubboServiceMetadataRepository;
import org.springframework.cloud.alibaba.dubbo.metadata.resolver.DubboTransportedAttributesResolver;
import org.springframework.cloud.alibaba.dubbo.service.DubboGenericServiceExecutionContextFactory;
import org.springframework.cloud.alibaba.dubbo.service.DubboGenericServiceFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.RetryLoadBalancerInterceptor;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.MethodMetadata;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
@AutoConfigureAfter(name={"org.springframework.cloud.client.loadbalancer.LoadBalancerAutoConfiguration"})
public class DubboLoadBalancedRestTemplateAutoConfiguration
implements BeanClassLoaderAware,
SmartInitializingSingleton {
    private static final Class<DubboTransported> DUBBO_TRANSPORTED_CLASS = DubboTransported.class;
    private static final String DUBBO_TRANSPORTED_CLASS_NAME = DUBBO_TRANSPORTED_CLASS.getName();
    @Autowired
    private DubboServiceMetadataRepository repository;
    @Autowired(required=false)
    private LoadBalancerInterceptor loadBalancerInterceptor;
    @Autowired(required=false)
    private RetryLoadBalancerInterceptor retryLoadBalancerInterceptor;
    @Autowired
    private ConfigurableListableBeanFactory beanFactory;
    @Autowired
    private DubboGenericServiceFactory serviceFactory;
    @Autowired
    private DubboGenericServiceExecutionContextFactory contextFactory;
    @Autowired
    private Environment environment;
    @LoadBalanced
    @Autowired(required=false)
    private Map<String, RestTemplate> restTemplates = Collections.emptyMap();
    private ClassLoader classLoader;
    private ClientHttpRequestInterceptor loadBalancerInterceptorBean;

    public void afterSingletonsInstantiated() {
        this.loadBalancerInterceptorBean = this.retryLoadBalancerInterceptor != null ? this.retryLoadBalancerInterceptor : this.loadBalancerInterceptor;
    }

    @EventListener(value={ApplicationStartedEvent.class})
    public void adaptRestTemplates() {
        DubboTransportedAttributesResolver attributesResolver = new DubboTransportedAttributesResolver((PropertyResolver)this.environment);
        for (Map.Entry<String, RestTemplate> entry : this.restTemplates.entrySet()) {
            String beanName = entry.getKey();
            Map<String, Object> dubboTranslatedAttributes = this.getDubboTranslatedAttributes(beanName, attributesResolver);
            if (CollectionUtils.isEmpty(dubboTranslatedAttributes)) continue;
            this.adaptRestTemplate(entry.getValue(), dubboTranslatedAttributes);
        }
    }

    private Map<String, Object> getDubboTranslatedAttributes(String beanName, DubboTransportedAttributesResolver attributesResolver) {
        Map<String, Object> attributes = Collections.emptyMap();
        BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
        if (beanDefinition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition;
            MethodMetadata factoryMethodMetadata = annotatedBeanDefinition.getFactoryMethodMetadata();
            attributes = factoryMethodMetadata != null ? factoryMethodMetadata.getAnnotationAttributes(DUBBO_TRANSPORTED_CLASS_NAME) : Collections.emptyMap();
        }
        return attributesResolver.resolve(attributes);
    }

    private void adaptRestTemplate(RestTemplate restTemplate, Map<String, Object> dubboTranslatedAttributes) {
        ArrayList<Object> interceptors = new ArrayList<Object>(restTemplate.getInterceptors());
        int index = this.loadBalancerInterceptorBean == null ? -1 : interceptors.indexOf(this.loadBalancerInterceptorBean);
        index = index < 0 ? 0 : index;
        interceptors.add(index++, new DubboMetadataInitializerInterceptor(this.repository));
        interceptors.add(index++, new DubboTransporterInterceptor(this.repository, restTemplate.getMessageConverters(), this.classLoader, dubboTranslatedAttributes, this.serviceFactory, this.contextFactory));
        restTemplate.setInterceptors(interceptors);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

