/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.alibaba.dubbo.env.DubboCloudProperties;
import org.springframework.cloud.alibaba.dubbo.service.DubboGenericServiceExecutionContextFactory;
import org.springframework.cloud.alibaba.dubbo.service.DubboGenericServiceFactory;
import org.springframework.cloud.alibaba.dubbo.service.parameter.PathVariableServiceParameterResolver;
import org.springframework.cloud.alibaba.dubbo.service.parameter.RequestBodyServiceParameterResolver;
import org.springframework.cloud.alibaba.dubbo.service.parameter.RequestHeaderServiceParameterResolver;
import org.springframework.cloud.alibaba.dubbo.service.parameter.RequestParamServiceParameterResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@Configuration
@EnableConfigurationProperties(value={DubboCloudProperties.class})
public class DubboServiceAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DubboGenericServiceFactory dubboGenericServiceFactory() {
        return new DubboGenericServiceFactory();
    }

    @Bean
    @Primary
    public PropertyResolver primaryPropertyResolver(Environment environment) {
        return environment;
    }

    @Configuration
    @Import(value={DubboGenericServiceExecutionContextFactory.class, RequestParamServiceParameterResolver.class, RequestBodyServiceParameterResolver.class, RequestHeaderServiceParameterResolver.class, PathVariableServiceParameterResolver.class})
    static class ParameterResolversConfiguration {
        ParameterResolversConfiguration() {
        }
    }
}

