/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.client.loadbalancer;

import java.io.IOException;
import java.util.List;
import org.apache.dubbo.rpc.service.GenericException;
import org.springframework.cloud.alibaba.dubbo.client.loadbalancer.DubboClientHttpResponse;
import org.springframework.cloud.alibaba.dubbo.client.loadbalancer.DubboHttpOutputMessage;
import org.springframework.cloud.alibaba.dubbo.http.converter.HttpMessageConverterHolder;
import org.springframework.cloud.alibaba.dubbo.http.util.HttpMessageConverterResolver;
import org.springframework.cloud.alibaba.dubbo.metadata.RequestMetadata;
import org.springframework.cloud.alibaba.dubbo.metadata.RestMethodMetadata;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;

class DubboClientHttpResponseFactory {
    private final HttpMessageConverterResolver httpMessageConverterResolver;

    public DubboClientHttpResponseFactory(List<HttpMessageConverter<?>> messageConverters, ClassLoader classLoader) {
        this.httpMessageConverterResolver = new HttpMessageConverterResolver(messageConverters, classLoader);
    }

    public ClientHttpResponse build(Object result, GenericException exception, RequestMetadata requestMetadata, RestMethodMetadata restMethodMetadata) {
        DubboHttpOutputMessage httpOutputMessage = new DubboHttpOutputMessage();
        HttpMessageConverterHolder httpMessageConverterHolder = this.httpMessageConverterResolver.resolve(requestMetadata, restMethodMetadata);
        if (httpMessageConverterHolder != null) {
            MediaType mediaType = httpMessageConverterHolder.getMediaType();
            HttpMessageConverter<?> converter = httpMessageConverterHolder.getConverter();
            try {
                converter.write(result, mediaType, (HttpOutputMessage)httpOutputMessage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new DubboClientHttpResponse(httpOutputMessage, exception);
    }
}

