/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.http.matcher;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.cloud.alibaba.dubbo.http.matcher.AbstractHttpRequestMatcher;
import org.springframework.cloud.alibaba.dubbo.http.matcher.ParamExpression;
import org.springframework.http.HttpRequest;
import org.springframework.util.CollectionUtils;

public class HttpRequestParamsMatcher
extends AbstractHttpRequestMatcher {
    private final Set<ParamExpression> expressions;

    public HttpRequestParamsMatcher(String ... params) {
        this.expressions = HttpRequestParamsMatcher.parseExpressions(params);
    }

    @Override
    public boolean match(HttpRequest request) {
        if (CollectionUtils.isEmpty(this.expressions)) {
            return true;
        }
        for (ParamExpression paramExpression : this.expressions) {
            if (!paramExpression.match(request)) continue;
            return true;
        }
        return false;
    }

    private static Set<ParamExpression> parseExpressions(String ... params) {
        LinkedHashSet<ParamExpression> expressions = new LinkedHashSet<ParamExpression>();
        for (String param : params) {
            expressions.add(new ParamExpression(param));
        }
        return expressions;
    }

    protected Collection<ParamExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }
}

