/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.metadata;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.dubbo.config.ProtocolConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.util.CollectionUtils;

public class DubboProtocolConfigSupplier
implements Supplier<ProtocolConfig> {
    private final ObjectProvider<Collection<ProtocolConfig>> protocols;

    public DubboProtocolConfigSupplier(ObjectProvider<Collection<ProtocolConfig>> protocols) {
        this.protocols = protocols;
    }

    @Override
    public ProtocolConfig get() {
        ProtocolConfig protocolConfig = null;
        Collection protocols = (Collection)this.protocols.getIfAvailable();
        if (!CollectionUtils.isEmpty((Collection)protocols)) {
            for (ProtocolConfig protocol : protocols) {
                String protocolName = protocol.getName();
                if (!"dubbo".equals(protocolName)) continue;
                protocolConfig = protocol;
                break;
            }
            if (protocolConfig == null) {
                Iterator iterator = protocols.iterator();
                ProtocolConfig protocolConfig2 = protocolConfig = iterator.hasNext() ? (ProtocolConfig)iterator.next() : null;
            }
        }
        if (protocolConfig == null) {
            protocolConfig = new ProtocolConfig();
            protocolConfig.setName("dubbo");
            protocolConfig.setPort(Integer.valueOf(-1));
        }
        return protocolConfig;
    }
}

