/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.springframework.cloud.alibaba.dubbo.metadata.MethodParameterMetadata;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MethodMetadata {
    private String name;
    @JsonProperty(value="return-type")
    private String returnType;
    private List<MethodParameterMetadata> params;
    @JsonIgnore
    private Method method;

    public MethodMetadata() {
        this.params = new LinkedList<MethodParameterMetadata>();
    }

    public MethodMetadata(Method method) {
        this.name = method.getName();
        this.returnType = method.getReturnType().getName();
        this.params = this.initParameters(method);
        this.method = method;
    }

    private List<MethodParameterMetadata> initParameters(Method method) {
        int parameterCount = method.getParameterCount();
        if (parameterCount < 1) {
            return Collections.emptyList();
        }
        ArrayList<MethodParameterMetadata> params = new ArrayList<MethodParameterMetadata>(parameterCount);
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameterCount; ++i) {
            Parameter parameter = parameters[i];
            MethodParameterMetadata param = this.toMethodParameterMetadata(i, parameter);
            params.add(param);
        }
        return params;
    }

    private MethodParameterMetadata toMethodParameterMetadata(int index, Parameter parameter) {
        MethodParameterMetadata metadata = new MethodParameterMetadata();
        metadata.setIndex(index);
        metadata.setName(parameter.getName());
        metadata.setType(parameter.getType().getTypeName());
        return metadata;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public List<MethodParameterMetadata> getParams() {
        return this.params;
    }

    public void setParams(List<MethodParameterMetadata> params) {
        this.params = params;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodMetadata that = (MethodMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.returnType, this.params);
    }

    public String toString() {
        return "MethodMetadata{name='" + this.name + '\'' + ", returnType='" + this.returnType + '\'' + ", params=" + this.params + ", method=" + this.method + '}';
    }
}

