/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import feign.RequestTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import org.springframework.cloud.alibaba.dubbo.http.util.HttpUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class RequestMetadata {
    private String method;
    private String path;
    @JsonProperty(value="params")
    private MultiValueMap<String, String> params = new LinkedMultiValueMap();
    @JsonProperty(value="headers")
    private HttpHeaders headers = new HttpHeaders();
    private Set<String> consumes = new LinkedHashSet<String>();
    private Set<String> produces = new LinkedHashSet<String>();

    public RequestMetadata() {
    }

    public RequestMetadata(RequestTemplate requestTemplate) {
        this.setMethod(requestTemplate.method());
        this.setPath(requestTemplate.url());
        this.params(requestTemplate.queries());
        this.headers(requestTemplate.headers());
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method.toUpperCase();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = HttpUtils.normalizePath(path);
    }

    public MultiValueMap<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, List<String>> params) {
        this.params(params);
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers(headers);
    }

    public Set<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    public Set<String> getProduces() {
        return this.produces;
    }

    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    @JsonIgnore
    public Set<String> getParamNames() {
        return this.params.keySet();
    }

    @JsonIgnore
    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @JsonIgnore
    public List<MediaType> getConsumeMediaTypes() {
        return RequestMetadata.toMediaTypes(this.consumes);
    }

    @JsonIgnore
    public List<MediaType> getProduceMediaTypes() {
        return RequestMetadata.toMediaTypes(this.produces);
    }

    public String getParameter(String name) {
        return (String)this.params.getFirst((Object)name);
    }

    public String getHeader(String name) {
        return this.headers.getFirst(name);
    }

    public RequestMetadata addParam(String name, String value) {
        RequestMetadata.add(name, value, this.params);
        return this;
    }

    public RequestMetadata addHeader(String name, String value) {
        RequestMetadata.add(name, value, (MultiValueMap<String, String>)this.headers);
        return this;
    }

    private <T extends Collection<String>> RequestMetadata params(Map<String, T> params) {
        RequestMetadata.addAll(params, this.params);
        return this;
    }

    private <T extends Collection<String>> RequestMetadata headers(Map<String, T> headers) {
        if (!CollectionUtils.isEmpty(headers)) {
            HttpHeaders httpHeaders = new HttpHeaders();
            RequestMetadata.addAll(headers, (MultiValueMap<String, String>)httpHeaders);
            RequestMetadata.mediaTypes(httpHeaders, "Content-Type", this.consumes);
            RequestMetadata.mediaTypes(httpHeaders, "Accept", this.produces);
            this.headers.putAll((Map)httpHeaders);
        }
        return this;
    }

    public static RequestMetadata getBestMatch(NavigableMap<RequestMetadata, RequestMetadata> requestMetadataMap, RequestMetadata requestMetadata) {
        RequestMetadata key = requestMetadata;
        RequestMetadata result = (RequestMetadata)requestMetadataMap.get(key);
        if (result == null) {
            NavigableMap<RequestMetadata, RequestMetadata> headMap = requestMetadataMap.headMap(key, true);
            result = headMap.isEmpty() ? null : (RequestMetadata)requestMetadataMap.get(headMap.lastKey());
        }
        return result;
    }

    private static void add(String key, String value, MultiValueMap<String, String> destination) {
        destination.add((Object)key, (Object)value);
    }

    private static <T extends Collection<String>> void addAll(Map<String, T> source, MultiValueMap<String, String> destination) {
        for (Map.Entry<String, T> entry : source.entrySet()) {
            String key = entry.getKey();
            for (String value : (Collection)entry.getValue()) {
                RequestMetadata.add(key, value, destination);
            }
        }
    }

    private static void mediaTypes(HttpHeaders httpHeaders, String headerName, Collection<String> destination) {
        List value = httpHeaders.get((Object)headerName);
        List mediaTypes = MediaType.parseMediaTypes((List)value);
        destination.addAll(RequestMetadata.toMediaTypeValues(mediaTypes));
    }

    private static List<String> toMediaTypeValues(List<MediaType> mediaTypes) {
        ArrayList<String> list = new ArrayList<String>(mediaTypes.size());
        for (MediaType mediaType : mediaTypes) {
            list.add(mediaType.toString());
        }
        return list;
    }

    private static List<MediaType> toMediaTypes(Collection<String> mediaTypeValues) {
        if (mediaTypeValues.isEmpty()) {
            return Collections.singletonList(MediaType.ALL);
        }
        return MediaType.parseMediaTypes(new LinkedList<String>(mediaTypeValues));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestMetadata)) {
            return false;
        }
        RequestMetadata that = (RequestMetadata)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.path, that.path) && Objects.equals(this.consumes, that.consumes) && Objects.equals(this.produces, that.produces) && Objects.equals(this.getParamNames(), that.getParamNames()) && Objects.equals(this.getHeaderNames(), that.getHeaderNames());
    }

    public int hashCode() {
        return Objects.hash(this.method, this.path, this.consumes, this.produces, this.getParamNames(), this.getHeaderNames());
    }

    public String toString() {
        return "RequestMetadata{method='" + this.method + '\'' + ", path='" + this.path + '\'' + ", params=" + this.params + ", headers=" + this.headers + ", consumes=" + this.consumes + ", produces=" + this.produces + '}';
    }
}

