/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.metadata.resolver;

import feign.Contract;
import feign.Feign;
import feign.MethodMetadata;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.cloud.alibaba.dubbo.annotation.DubboTransported;
import org.springframework.cloud.alibaba.dubbo.metadata.DubboTransportedMethodMetadata;
import org.springframework.cloud.alibaba.dubbo.metadata.RestMethodMetadata;
import org.springframework.cloud.alibaba.dubbo.metadata.resolver.DubboTransportedAttributesResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.PropertyResolver;

public class DubboTransportedMethodMetadataResolver {
    private static final Class<DubboTransported> DUBBO_TRANSPORTED_CLASS = DubboTransported.class;
    private final DubboTransportedAttributesResolver attributesResolver;
    private final Contract contract;

    public DubboTransportedMethodMetadataResolver(PropertyResolver propertyResolver, Contract contract) {
        this.attributesResolver = new DubboTransportedAttributesResolver(propertyResolver);
        this.contract = contract;
    }

    public Map<DubboTransportedMethodMetadata, RestMethodMetadata> resolve(Class<?> targetType) {
        Set<DubboTransportedMethodMetadata> dubboTransportedMethodMetadataSet = this.resolveDubboTransportedMethodMetadataSet(targetType);
        Map<String, RestMethodMetadata> restMethodMetadataMap = this.resolveRestRequestMetadataMap(targetType);
        return dubboTransportedMethodMetadataSet.stream().collect(Collectors.toMap(methodMetadata -> methodMetadata, methodMetadata -> {
            RestMethodMetadata restMethodMetadata = (RestMethodMetadata)restMethodMetadataMap.get(Feign.configKey((Class)targetType, (Method)methodMetadata.getMethod()));
            restMethodMetadata.setMethod(methodMetadata.getMethodMetadata());
            return restMethodMetadata;
        }));
    }

    protected Set<DubboTransportedMethodMetadata> resolveDubboTransportedMethodMetadataSet(Class<?> targetType) {
        Method[] methods = targetType.getMethods();
        LinkedHashSet<DubboTransportedMethodMetadata> methodMetadataSet = new LinkedHashSet<DubboTransportedMethodMetadata>();
        for (Method method : methods) {
            DubboTransported dubboTransported = this.resolveDubboTransported(method);
            if (dubboTransported == null) continue;
            DubboTransportedMethodMetadata methodMetadata = this.createDubboTransportedMethodMetadata(method, dubboTransported);
            methodMetadataSet.add(methodMetadata);
        }
        return methodMetadataSet;
    }

    private Map<String, RestMethodMetadata> resolveRestRequestMetadataMap(Class<?> targetType) {
        return this.contract.parseAndValidatateMetadata(targetType).stream().collect(Collectors.toMap(MethodMetadata::configKey, this::restMethodMetadata));
    }

    private RestMethodMetadata restMethodMetadata(MethodMetadata methodMetadata) {
        return new RestMethodMetadata(methodMetadata);
    }

    private DubboTransportedMethodMetadata createDubboTransportedMethodMetadata(Method method, DubboTransported dubboTransported) {
        Map<String, Object> attributes = this.attributesResolver.resolve(dubboTransported);
        return new DubboTransportedMethodMetadata(method, attributes);
    }

    private DubboTransported resolveDubboTransported(Method method) {
        DubboTransported dubboTransported = (DubboTransported)AnnotationUtils.findAnnotation((Method)method, DUBBO_TRANSPORTED_CLASS);
        if (dubboTransported == null) {
            Class<?> declaringClass = method.getDeclaringClass();
            dubboTransported = (DubboTransported)AnnotationUtils.findAnnotation(declaringClass, DUBBO_TRANSPORTED_CLASS);
        }
        return dubboTransported;
    }
}

