/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.registry;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.springframework.cloud.alibaba.dubbo.metadata.repository.DubboServiceMetadataRepository;
import org.springframework.cloud.alibaba.dubbo.registry.SpringCloudRegistry;
import org.springframework.cloud.alibaba.dubbo.service.DubboMetadataServiceProxy;
import org.springframework.cloud.alibaba.dubbo.util.JSONUtils;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringCloudRegistryFactory
implements RegistryFactory {
    private static String SERVICES_LOOKUP_SCHEDULER_THREAD_NAME_PREFIX = System.getProperty("dubbo.services.lookup.scheduler.thread.name.prefix ", "dubbo-services-lookup-");
    private static ConfigurableApplicationContext applicationContext;
    private final ScheduledExecutorService servicesLookupScheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(SERVICES_LOOKUP_SCHEDULER_THREAD_NAME_PREFIX));
    private DiscoveryClient discoveryClient;
    private DubboServiceMetadataRepository dubboServiceMetadataRepository;
    private DubboMetadataServiceProxy dubboMetadataConfigServiceProxy;
    private JSONUtils jsonUtils;
    private volatile boolean initialized = false;

    protected void init() {
        if (this.initialized || applicationContext == null) {
            return;
        }
        this.discoveryClient = (DiscoveryClient)applicationContext.getBean(DiscoveryClient.class);
        this.dubboServiceMetadataRepository = (DubboServiceMetadataRepository)applicationContext.getBean(DubboServiceMetadataRepository.class);
        this.dubboMetadataConfigServiceProxy = (DubboMetadataServiceProxy)applicationContext.getBean(DubboMetadataServiceProxy.class);
        this.jsonUtils = (JSONUtils)applicationContext.getBean(JSONUtils.class);
    }

    public Registry getRegistry(URL url) {
        this.init();
        return new SpringCloudRegistry(url, this.discoveryClient, this.dubboServiceMetadataRepository, this.dubboMetadataConfigServiceProxy, this.jsonUtils, this.servicesLookupScheduler);
    }

    public static void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        SpringCloudRegistryFactory.applicationContext = applicationContext;
    }
}

