/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.service;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PreDestroy;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.cloud.alibaba.dubbo.metadata.DubboRestServiceMetadata;
import org.springframework.cloud.alibaba.dubbo.metadata.ServiceRestMetadata;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

public class DubboGenericServiceFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<Integer, ReferenceBean<GenericService>> cache = new ConcurrentHashMap<Integer, ReferenceBean<GenericService>>();

    public GenericService create(DubboRestServiceMetadata dubboServiceMetadata, Map<String, Object> dubboTranslatedAttributes) {
        ReferenceBean<GenericService> referenceBean = this.build(dubboServiceMetadata.getServiceRestMetadata(), dubboTranslatedAttributes);
        return referenceBean == null ? null : (GenericService)referenceBean.get();
    }

    public GenericService create(String serviceName, Class<?> serviceClass, String version) {
        String interfaceName = serviceClass.getName();
        ReferenceBean<GenericService> referenceBean = this.build(interfaceName, version, serviceName, Collections.emptyMap());
        return (GenericService)referenceBean.get();
    }

    private ReferenceBean<GenericService> build(ServiceRestMetadata serviceRestMetadata, Map<String, Object> dubboTranslatedAttributes) {
        String urlValue = serviceRestMetadata.getUrl();
        URL url = URL.valueOf((String)urlValue);
        String interfaceName = url.getServiceInterface();
        String version = url.getParameter("version");
        String group = url.getParameter("group");
        return this.build(interfaceName, version, group, dubboTranslatedAttributes);
    }

    private ReferenceBean<GenericService> build(String interfaceName, String version, String group, Map<String, Object> dubboTranslatedAttributes) {
        Integer key = Objects.hash(interfaceName, version, group, dubboTranslatedAttributes);
        ReferenceBean referenceBean = (ReferenceBean)this.cache.get(key);
        if (referenceBean == null) {
            referenceBean = new ReferenceBean();
            referenceBean.setGeneric(Boolean.valueOf(true));
            referenceBean.setInterface(interfaceName);
            referenceBean.setVersion(version);
            referenceBean.setGroup(group);
            this.bindReferenceBean((ReferenceBean<GenericService>)referenceBean, dubboTranslatedAttributes);
        }
        return referenceBean;
    }

    private void bindReferenceBean(ReferenceBean<GenericService> referenceBean, Map<String, Object> dubboTranslatedAttributes) {
        DataBinder dataBinder = new DataBinder(referenceBean);
        dataBinder.registerCustomEditor(String.class, "filter", (PropertyEditor)new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(String.class, "listener", (PropertyEditor)new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(Map.class, "parameters", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) throws IllegalArgumentException {
                String content = StringUtils.trimAllWhitespace((String)text);
                if (!StringUtils.hasText((String)content)) {
                    return;
                }
                content = StringUtils.replace((String)content, (String)"=", (String)",");
                content = StringUtils.replace((String)content, (String)":", (String)",");
                Map parameters = CollectionUtils.toStringMap((String[])StringUtils.commaDelimitedListToStringArray((String)content));
                this.setValue(parameters);
            }
        });
        dataBinder.bind((PropertyValues)new MutablePropertyValues(dubboTranslatedAttributes));
    }

    @PreDestroy
    public void destroy() {
        this.destroyReferenceBeans();
        this.cache.values();
    }

    private void destroyReferenceBeans() {
        Collection referenceBeans = this.cache.values();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The Dubbo GenericService ReferenceBeans are destroying...");
        }
        for (ReferenceBean referenceBean : referenceBeans) {
            referenceBean.destroy();
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("Destroyed the ReferenceBean  : {} ", (Object)referenceBean);
        }
    }
}

