/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.actuate.metrics;

import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.cloud.aws.actuate.metrics.CloudWatchMetricSender;

public class CloudWatchMetricWriter
implements MetricWriter {
    private final CloudWatchMetricSender sender;

    public CloudWatchMetricWriter(CloudWatchMetricSender sender) {
        this.sender = sender;
    }

    public void increment(Delta<?> delta) {
        this.sender.send(CloudWatchMetricWriter.createMetricDatumForCounterValue(delta));
    }

    public void set(Metric<?> value) {
        this.sender.send(CloudWatchMetricWriter.createMetricDatumForUnknownValue(value));
    }

    public void reset(String metricName) {
        this.sender.send(CloudWatchMetricWriter.createEmptyMetricDatum(metricName));
    }

    protected static MetricDatum createEmptyMetricDatum(String metricName) {
        return new MetricDatum().withMetricName(metricName).withValue(Double.valueOf(0.0));
    }

    protected static MetricDatum createMetricDatumForCounterValue(Delta<?> delta) {
        return new MetricDatum().withMetricName(delta.getName()).withTimestamp(delta.getTimestamp()).withValue(Double.valueOf(delta.getValue().doubleValue())).withUnit(StandardUnit.Count);
    }

    protected static MetricDatum createMetricDatumForUnknownValue(Metric<?> value) {
        String name = value.getName();
        MetricDatum metricDatum = new MetricDatum().withMetricName(name).withTimestamp(value.getTimestamp());
        if (name.contains("timer.") && !name.contains("gauge.") && !name.contains("counter.")) {
            metricDatum.withValue(Double.valueOf(value.getValue().doubleValue())).withUnit(StandardUnit.Milliseconds);
        } else {
            metricDatum.withValue(Double.valueOf(value.getValue().doubleValue())).withUnit(StandardUnit.Count);
        }
        return metricDatum;
    }
}

