/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.support.io;

import com.amazonaws.services.s3.AmazonS3;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.aws.core.io.s3.PathMatchingSimpleStorageResourcePatternResolver;
import org.springframework.cloud.aws.core.io.s3.SimpleStorageResourceLoader;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.Ordered;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.task.TaskExecutor;

public class ResourceLoaderBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryPostProcessor,
Ordered,
ResourceLoaderAware {
    private final AmazonS3 amazonS3;
    private ResourceLoader resourceLoader;
    private TaskExecutor executor;

    public ResourceLoaderBeanPostProcessor(AmazonS3 amazonS3) {
        this.amazonS3 = amazonS3;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.executor = taskExecutor;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)bean).setResourceLoader(this.resourceLoader);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        SimpleStorageResourceLoader simpleStorageResourceLoader = new SimpleStorageResourceLoader(this.amazonS3, this.resourceLoader);
        if (this.executor != null) {
            simpleStorageResourceLoader.setTaskExecutor(this.executor);
        }
        try {
            simpleStorageResourceLoader.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new BeanInstantiationException(SimpleStorageResourceLoader.class, "Error instantiating class", (Throwable)e);
        }
        this.resourceLoader = new PathMatchingSimpleStorageResourcePatternResolver(this.amazonS3, (ResourceLoader)simpleStorageResourceLoader, (ResourcePatternResolver)this.resourceLoader);
        beanFactory.registerResolvableDependency(ResourceLoader.class, (Object)this.resourceLoader);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

