/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.support.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.NumberUtils;

public class NotificationRequestConverter
implements MessageConverter {
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final MessageConverter payloadConverter;

    public NotificationRequestConverter(MessageConverter payloadConverter) {
        this.payloadConverter = payloadConverter;
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        JsonNode jsonNode;
        Assert.notNull(message, (String)"message must not be null");
        Assert.notNull(targetClass, (String)"target class must not be null");
        try {
            jsonNode = this.jsonMapper.readTree(message.getPayload().toString());
        }
        catch (Exception e) {
            throw new MessageConversionException("Could not read JSON", (Throwable)e);
        }
        if (!jsonNode.has("Type")) {
            throw new MessageConversionException("Payload: '" + message.getPayload() + "' does not contain a Type attribute", null);
        }
        if (!"Notification".equals(jsonNode.findValue("Type").asText())) {
            throw new MessageConversionException("Payload: '" + message.getPayload() + "' is not a valid notification", null);
        }
        if (!jsonNode.has("Message")) {
            throw new MessageConversionException("Payload: '" + message.getPayload() + "' does not contain a message", null);
        }
        String messagePayload = jsonNode.findPath("Message").asText();
        GenericMessage genericMessage = new GenericMessage((Object)messagePayload, NotificationRequestConverter.getMessageAttributesAsMessageHeaders(jsonNode.findPath("MessageAttributes")));
        return new NotificationRequest(jsonNode.findPath("Subject").asText(), this.payloadConverter.fromMessage((Message)genericMessage, targetClass));
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        throw new UnsupportedOperationException("This converter only supports reading a SNS notification and not writing them");
    }

    private static Map<String, Object> getMessageAttributesAsMessageHeaders(JsonNode message) {
        HashMap<String, Object> messageHeaders = new HashMap<String, Object>();
        Iterator fieldNames = message.fieldNames();
        while (fieldNames.hasNext()) {
            String attributeName = (String)fieldNames.next();
            String attributeValue = message.get(attributeName).get("Value").asText();
            String attributeType = message.get(attributeName).get("Type").asText();
            if ("contentType".equals(attributeName)) {
                messageHeaders.put("contentType", MimeType.valueOf((String)attributeValue));
                continue;
            }
            if ("id".equals(attributeName)) {
                messageHeaders.put("id", UUID.fromString(attributeValue));
                continue;
            }
            if ("String".equals(attributeType)) {
                messageHeaders.put(attributeName, attributeValue);
                continue;
            }
            if (attributeType.startsWith("Number")) {
                Object numberValue = NotificationRequestConverter.getNumberValue(attributeType, attributeValue);
                if (numberValue == null) continue;
                messageHeaders.put(attributeName, numberValue);
                continue;
            }
            if (!"Binary".equals(attributeName)) continue;
            messageHeaders.put(attributeName, ByteBuffer.wrap(attributeType.getBytes()));
        }
        return messageHeaders;
    }

    private static Object getNumberValue(String attributeType, String attributeValue) {
        String numberType = attributeType.substring("Number".length() + 1);
        try {
            Class<Number> numberTypeClass = Class.forName(numberType).asSubclass(Number.class);
            return NumberUtils.parseNumber((String)attributeValue, numberTypeClass);
        }
        catch (ClassNotFoundException e) {
            throw new MessagingException(String.format("Message attribute with value '%s' and data type '%s' could not be converted into a Number because target class was not found.", attributeValue, attributeType), (Throwable)e);
        }
    }

    public static class NotificationRequest {
        private final String subject;
        private final Object message;

        public NotificationRequest(String subject, Object message) {
            this.subject = subject;
            this.message = message;
        }

        public String getSubject() {
            return this.subject;
        }

        public Object getMessage() {
            return this.message;
        }
    }
}

